/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.process;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.module.s3.adapters.S3ConnectorConnectionIdentifierAdapter;
import org.mule.module.s3.connection.ConnectionManager;
import org.mule.module.s3.connection.UnableToAcquireConnectionException;
import org.mule.module.s3.connection.UnableToReleaseConnectionException;
import org.mule.module.s3.connectivity.S3ConnectorConnectionKey;
import org.mule.module.s3.processors.ConnectivityProcessor;
import org.mule.security.oauth.callback.ProcessCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ConnectorManagedConnectionProcessInterceptor<T>
extends ExpressionEvaluatorSupport
implements ProcessInterceptor<T, S3ConnectorConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(S3ConnectorManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<S3ConnectorConnectionKey, S3ConnectorConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, S3ConnectorConnectionIdentifierAdapter> next;

    public S3ConnectorManagedConnectionProcessInterceptor(ProcessInterceptor<T, S3ConnectorConnectionIdentifierAdapter> next, ConnectionManager<S3ConnectorConnectionKey, S3ConnectorConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    public T execute(ProcessCallback<T, S3ConnectorConnectionIdentifierAdapter> processCallback, S3ConnectorConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        Object connectivityProcessor;
        S3ConnectorConnectionIdentifierAdapter connection = null;
        S3ConnectorConnectionKey key = null;
        if (this.hasConnectionKeysOverride(messageProcessor).booleanValue()) {
            connectivityProcessor = (ConnectivityProcessor)messageProcessor;
            String _transformedAccessKey = (String)this.evaluateAndTransform(this.muleContext, event, connectivityProcessor.typeFor("_accessKeyType"), null, connectivityProcessor.getAccessKey());
            if (_transformedAccessKey == null) {
                throw new UnableToAcquireConnectionException("Parameter accessKey in method connect can't be null because is not @Optional");
            }
            String _transformedSecretKey = (String)this.evaluateAndTransform(this.muleContext, event, connectivityProcessor.typeFor("_secretKeyType"), null, connectivityProcessor.getSecretKey());
            if (_transformedSecretKey == null) {
                throw new UnableToAcquireConnectionException("Parameter secretKey in method connect can't be null because is not @Optional");
            }
            key = new S3ConnectorConnectionKey(_transformedAccessKey, _transformedSecretKey);
        } else {
            key = this.connectionManager.getEvaluatedConnectionKey(event);
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = this.connectionManager.acquireConnection(key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            connectivityProcessor = this.next.execute(processCallback, (Object)connection, messageProcessor, event);
            return (T)connectivityProcessor;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        if (connection == null) continue;
                        this.connectionManager.destroyConnection(key, connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection(key, connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    private Boolean hasConnectionKeysOverride(MessageProcessor messageProcessor) {
        if (messageProcessor == null || !(messageProcessor instanceof ConnectivityProcessor)) {
            return false;
        }
        ConnectivityProcessor connectivityProcessor = (ConnectivityProcessor)messageProcessor;
        if (connectivityProcessor.getAccessKey() != null) {
            return true;
        }
        return false;
    }

    public T execute(ProcessCallback<T, S3ConnectorConnectionIdentifierAdapter> processCallback, S3ConnectorConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

