/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4_4_1.shade.protocol;

import java.io.IOException;
import org.apache.http.4_4_1.shade.HttpEntity;
import org.apache.http.4_4_1.shade.HttpEntityEnclosingRequest;
import org.apache.http.4_4_1.shade.HttpException;
import org.apache.http.4_4_1.shade.HttpRequest;
import org.apache.http.4_4_1.shade.HttpRequestInterceptor;
import org.apache.http.4_4_1.shade.HttpVersion;
import org.apache.http.4_4_1.shade.ProtocolVersion;
import org.apache.http.4_4_1.shade.annotation.Immutable;
import org.apache.http.4_4_1.shade.protocol.HttpContext;
import org.apache.http.4_4_1.shade.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

