/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4_4_1.shade.impl.io;

import java.io.IOException;
import org.apache.http.4_4_1.shade.HttpException;
import org.apache.http.4_4_1.shade.HttpResponse;
import org.apache.http.4_4_1.shade.HttpResponseFactory;
import org.apache.http.4_4_1.shade.NoHttpResponseException;
import org.apache.http.4_4_1.shade.ParseException;
import org.apache.http.4_4_1.shade.StatusLine;
import org.apache.http.4_4_1.shade.annotation.NotThreadSafe;
import org.apache.http.4_4_1.shade.config.MessageConstraints;
import org.apache.http.4_4_1.shade.impl.DefaultHttpResponseFactory;
import org.apache.http.4_4_1.shade.impl.io.AbstractMessageParser;
import org.apache.http.4_4_1.shade.io.SessionInputBuffer;
import org.apache.http.4_4_1.shade.message.LineParser;
import org.apache.http.4_4_1.shade.message.ParserCursor;
import org.apache.http.4_4_1.shade.params.HttpParams;
import org.apache.http.4_4_1.shade.util.Args;
import org.apache.http.4_4_1.shade.util.CharArrayBuffer;

@NotThreadSafe
public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.responseFactory = Args.notNull(responseFactory, "Response factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

