/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4_4_1.shade.impl.entity;

import java.io.IOException;
import org.apache.http.4_4_1.shade.Header;
import org.apache.http.4_4_1.shade.HttpEntity;
import org.apache.http.4_4_1.shade.HttpException;
import org.apache.http.4_4_1.shade.HttpMessage;
import org.apache.http.4_4_1.shade.annotation.Immutable;
import org.apache.http.4_4_1.shade.entity.BasicHttpEntity;
import org.apache.http.4_4_1.shade.entity.ContentLengthStrategy;
import org.apache.http.4_4_1.shade.impl.io.ChunkedInputStream;
import org.apache.http.4_4_1.shade.impl.io.ContentLengthInputStream;
import org.apache.http.4_4_1.shade.impl.io.IdentityInputStream;
import org.apache.http.4_4_1.shade.io.SessionInputBuffer;
import org.apache.http.4_4_1.shade.util.Args;

@Deprecated
@Immutable
public class EntityDeserializer {
    private final ContentLengthStrategy lenStrategy;

    public EntityDeserializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected BasicHttpEntity doDeserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(new ChunkedInputStream(inbuffer));
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(new IdentityInputStream(inbuffer));
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(new ContentLengthInputStream(inbuffer, len));
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    public HttpEntity deserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        Args.notNull(inbuffer, "Session input buffer");
        Args.notNull(message, "HTTP message");
        return this.doDeserialize(inbuffer, message);
    }
}

