/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4_4_1.shade.impl.cookie;

import java.util.Date;
import org.apache.http.4_4_1.shade.annotation.Immutable;
import org.apache.http.4_4_1.shade.client.utils.DateUtils;
import org.apache.http.4_4_1.shade.cookie.CommonCookieAttributeHandler;
import org.apache.http.4_4_1.shade.cookie.MalformedCookieException;
import org.apache.http.4_4_1.shade.cookie.SetCookie;
import org.apache.http.4_4_1.shade.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.http.4_4_1.shade.util.Args;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "Array of date patterns");
        this.datepatterns = datepatterns;
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date expiry = DateUtils.parseDate(value, this.datepatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value);
        }
        cookie.setExpiryDate(expiry);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

