/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4_4_1.shade.impl.client;

import org.apache.http.4_4_1.shade.HeaderElement;
import org.apache.http.4_4_1.shade.HttpResponse;
import org.apache.http.4_4_1.shade.annotation.Immutable;
import org.apache.http.4_4_1.shade.conn.ConnectionKeepAliveStrategy;
import org.apache.http.4_4_1.shade.message.BasicHeaderElementIterator;
import org.apache.http.4_4_1.shade.protocol.HttpContext;
import org.apache.http.4_4_1.shade.util.Args;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

