/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4_4_1.shade.client.protocol;

import java.io.IOException;
import java.util.Collection;
import org.apache.http.4_4_1.shade.Header;
import org.apache.http.4_4_1.shade.HttpException;
import org.apache.http.4_4_1.shade.HttpRequest;
import org.apache.http.4_4_1.shade.HttpRequestInterceptor;
import org.apache.http.4_4_1.shade.annotation.Immutable;
import org.apache.http.4_4_1.shade.protocol.HttpContext;
import org.apache.http.4_4_1.shade.util.Args;

@Immutable
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        Collection<? extends Header> defHeaders = (Collection<? extends Header>)request.getParams().getParameter("http.default-headers");
        if (defHeaders == null) {
            defHeaders = this.defaultHeaders;
        }
        if (defHeaders != null) {
            for (Header header : defHeaders) {
                request.addHeader(header);
            }
        }
    }
}

