/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1_7_13.shade.util;

import com.amazonaws.1_7_13.shade.util.Base64;
import com.amazonaws.1_7_13.shade.util.DateUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;

public class StringUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static Integer toInteger(StringBuilder value) {
        return Integer.parseInt(value.toString());
    }

    public static String toString(StringBuilder value) {
        return value.toString();
    }

    public static Boolean toBoolean(StringBuilder value) {
        return Boolean.getBoolean(value.toString());
    }

    public static String fromInteger(Integer value) {
        return Integer.toString(value);
    }

    public static String fromLong(Long value) {
        return Long.toString(value);
    }

    public static String fromString(String value) {
        return value;
    }

    public static String fromBoolean(Boolean value) {
        return Boolean.toString(value);
    }

    public static String fromBigInteger(BigInteger value) {
        return value.toString();
    }

    public static String fromBigDecimal(BigDecimal value) {
        return value.toString();
    }

    public static BigInteger toBigInteger(String s) {
        return new BigInteger(s);
    }

    public static BigDecimal toBigDecimal(String s) {
        return new BigDecimal(s);
    }

    public static String fromFloat(Float value) {
        return Float.toString(value.floatValue());
    }

    public static String fromDate(Date value) {
        return DateUtils.formatISO8601Date(value);
    }

    public static String fromDouble(Double d) {
        return Double.toString(d);
    }

    public static String fromByte(Byte b) {
        return Byte.toString(b);
    }

    public static String fromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return Base64.encodeAsString(byteBuffer.array());
        }
        byte[] binaryData = new byte[byteBuffer.limit()];
        byteBuffer.get(binaryData);
        return Base64.encodeAsString(binaryData);
    }

    public static String replace(String originalString, String partToMatch, String replacement) {
        StringBuffer buffer = new StringBuffer(originalString.length());
        buffer.append(originalString);
        int indexOf = buffer.indexOf(partToMatch);
        while (indexOf != -1) {
            buffer = buffer.replace(indexOf, indexOf + partToMatch.length(), replacement);
            indexOf = buffer.indexOf(partToMatch);
        }
        return buffer.toString();
    }

    public static String join(String joiner, String ... parts) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            builder.append(parts[i]);
            if (i >= parts.length - 1) continue;
            builder.append(joiner);
        }
        return builder.toString();
    }
}

