/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1_7_13.shade.util;

import com.amazonaws.1_7_13.shade.util.JodaTime;
import java.util.Date;
import java.util.Locale;
import org.apache.http.4_4_1.shade.annotation.ThreadSafe;
import org.joda.time.2_7.shade.DateTimeZone;
import org.joda.time.2_7.shade.format.DateTimeFormat;
import org.joda.time.2_7.shade.format.DateTimeFormatter;
import org.joda.time.2_7.shade.format.ISODateTimeFormat;
import org.joda.time.2_7.shade.tz.FixedDateTimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DateUtils {
    private static final DateTimeZone GMT = new FixedDateTimeZone("GMT", "GMT", 0, 0);
    protected static final DateTimeFormatter iso8601DateFormat = ISODateTimeFormat.dateTime().withZone(GMT);
    protected static final DateTimeFormatter alternateIso8601DateFormat = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(GMT);
    protected static final DateTimeFormatter rfc822DateFormat = DateTimeFormat.forPattern("EEE, dd MMM yyyy HH:mm:ss z").withLocale(Locale.US).withZone(GMT);
    protected static final DateTimeFormatter compressedIso8601DateFormat = DateTimeFormat.forPattern("yyyyMMdd'T'HHmmss'Z'").withZone(GMT);

    @Deprecated
    public Date parseIso8601Date(String dateString) {
        return DateUtils.parseISO8601Date(dateString);
    }

    public static Date parseISO8601Date(String dateString) {
        try {
            return DateUtils.doParseISO8601Date(dateString);
        }
        catch (RuntimeException ex) {
            throw DateUtils.handleException(ex);
        }
    }

    static Date doParseISO8601Date(String dateString) {
        try {
            return new Date(iso8601DateFormat.parseMillis(dateString));
        }
        catch (IllegalArgumentException e) {
            return new Date(alternateIso8601DateFormat.parseMillis(dateString));
        }
    }

    private static <E extends RuntimeException> E handleException(E ex) {
        if (JodaTime.hasExpectedBehavior()) {
            return ex;
        }
        throw new IllegalStateException("Joda-time 2.2 or later version is required, but found version: " + JodaTime.getVersion(), ex);
    }

    @Deprecated
    public String formatIso8601Date(Date date) {
        return DateUtils.formatISO8601Date(date);
    }

    public static String formatISO8601Date(Date date) {
        try {
            return iso8601DateFormat.print(date.getTime());
        }
        catch (RuntimeException ex) {
            throw DateUtils.handleException(ex);
        }
    }

    @Deprecated
    public Date parseRfc822Date(String dateString) {
        return DateUtils.parseRFC822Date(dateString);
    }

    public static Date parseRFC822Date(String dateString) {
        try {
            return new Date(rfc822DateFormat.parseMillis(dateString));
        }
        catch (RuntimeException ex) {
            throw DateUtils.handleException(ex);
        }
    }

    @Deprecated
    public String formatRfc822Date(Date date) {
        return DateUtils.formatRFC822Date(date);
    }

    public static String formatRFC822Date(Date date) {
        try {
            return rfc822DateFormat.print(date.getTime());
        }
        catch (RuntimeException ex) {
            throw DateUtils.handleException(ex);
        }
    }

    @Deprecated
    public Date parseCompressedIso8601Date(String dateString) {
        return DateUtils.parseCompressedISO8601Date(dateString);
    }

    public static Date parseCompressedISO8601Date(String dateString) {
        try {
            return new Date(compressedIso8601DateFormat.parseMillis(dateString));
        }
        catch (RuntimeException ex) {
            throw DateUtils.handleException(ex);
        }
    }
}

