/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1_7_13.shade.services.s3.model;

import com.amazonaws.1_7_13.shade.internal.MetricAware;
import com.amazonaws.1_7_13.shade.internal.SdkFilterInputStream;
import com.amazonaws.1_7_13.shade.metrics.AwsSdkMetrics;
import com.amazonaws.1_7_13.shade.metrics.MetricFilterInputStream;
import com.amazonaws.1_7_13.shade.services.s3.metrics.S3ServiceMetric;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.LogFactory;
import org.apache.http.4_4_1.shade.client.methods.HttpRequestBase;

public class S3ObjectInputStream
extends SdkFilterInputStream {
    private final HttpRequestBase httpRequest;

    public S3ObjectInputStream(InputStream in, HttpRequestBase httpRequest) {
        this(in, httpRequest, S3ObjectInputStream.wrapWithByteCounting(in));
    }

    public S3ObjectInputStream(InputStream in, HttpRequestBase httpRequest, boolean collectMetrics) {
        super(collectMetrics ? new MetricFilterInputStream(S3ServiceMetric.S3DownloadThroughput, in) : in);
        this.httpRequest = httpRequest;
    }

    private static boolean wrapWithByteCounting(InputStream in) {
        if (!AwsSdkMetrics.isMetricsEnabled()) {
            return false;
        }
        if (in instanceof MetricAware) {
            MetricAware aware = (MetricAware)((Object)in);
            return !aware.isMetricActivated();
        }
        return true;
    }

    public void abort() {
        this.getHttpRequest().abort();
        try {
            this.close();
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).debug((Object)"FYI", (Throwable)e);
        }
    }

    public HttpRequestBase getHttpRequest() {
        return this.httpRequest;
    }
}

