/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1_7_13.shade.services.s3.internal;

import com.amazonaws.1_7_13.shade.AmazonClientException;
import com.amazonaws.1_7_13.shade.Request;
import com.amazonaws.1_7_13.shade.auth.AWSCredentials;
import com.amazonaws.1_7_13.shade.auth.AWSSessionCredentials;
import com.amazonaws.1_7_13.shade.auth.AbstractAWSSigner;
import com.amazonaws.1_7_13.shade.auth.SigningAlgorithm;
import com.amazonaws.1_7_13.shade.services.s3.internal.RestUtils;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3QueryStringSigner<T>
extends AbstractAWSSigner {
    private final String httpVerb;
    private final String resourcePath;
    private final Date expiration;

    public S3QueryStringSigner(String httpVerb, String resourcePath, Date expiration) {
        this.httpVerb = httpVerb;
        this.resourcePath = resourcePath;
        this.expiration = expiration;
        if (resourcePath == null) {
            throw new IllegalArgumentException("Parameter resourcePath is empty");
        }
    }

    @Override
    public void sign(Request<?> request, AWSCredentials credentials) throws AmazonClientException {
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        if (sanitizedCredentials instanceof AWSSessionCredentials) {
            this.addSessionCredentials(request, (AWSSessionCredentials)sanitizedCredentials);
        }
        String expirationInSeconds = Long.toString(this.expiration.getTime() / 1000L);
        String canonicalString = RestUtils.makeS3CanonicalString(this.httpVerb, this.resourcePath, request, expirationInSeconds);
        String signature = super.signAndBase64Encode(canonicalString, sanitizedCredentials.getAWSSecretKey(), SigningAlgorithm.HmacSHA1);
        request.addParameter("AWSAccessKeyId", sanitizedCredentials.getAWSAccessKeyId());
        request.addParameter("Expires", expirationInSeconds);
        request.addParameter("Signature", signature);
    }

    @Override
    protected void addSessionCredentials(Request<?> request, AWSSessionCredentials credentials) {
        request.addParameter("x-amz-security-token", credentials.getSessionToken());
    }
}

