/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1_7_13.shade.internal;

import com.amazonaws.1_7_13.shade.AbortedException;
import com.amazonaws.1_7_13.shade.internal.MetricAware;
import com.amazonaws.1_7_13.shade.util.SdkRuntime;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SdkFilterInputStream
extends FilterInputStream
implements MetricAware {
    protected SdkFilterInputStream(InputStream in) {
        super(in);
    }

    public boolean isMetricActivated() {
        if (this.in instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)this.in);
            return metricAware.isMetricActivated();
        }
        return false;
    }

    protected final void abortIfNeeded() {
        if (SdkRuntime.shouldAbort()) {
            this.abort();
            throw new AbortedException();
        }
    }

    protected void abort() {
    }

    public int read() throws IOException {
        this.abortIfNeeded();
        return this.in.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.abortIfNeeded();
        return this.in.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        this.abortIfNeeded();
        return this.in.skip(n);
    }

    public int available() throws IOException {
        this.abortIfNeeded();
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
        this.abortIfNeeded();
    }

    public synchronized void mark(int readlimit) {
        this.abortIfNeeded();
        this.in.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.abortIfNeeded();
        this.in.reset();
    }

    public boolean markSupported() {
        this.abortIfNeeded();
        return this.in.markSupported();
    }
}

