/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1_7_13.shade.http;

import com.amazonaws.1_7_13.shade.AmazonClientException;
import com.amazonaws.1_7_13.shade.ClientConfiguration;
import com.amazonaws.1_7_13.shade.Request;
import com.amazonaws.1_7_13.shade.http.ExecutionContext;
import com.amazonaws.1_7_13.shade.http.HttpMethodName;
import com.amazonaws.1_7_13.shade.http.RepeatableInputStreamRequestEntity;
import com.amazonaws.1_7_13.shade.util.HttpUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Map;
import org.apache.http.4_4_1.shade.HttpEntity;
import org.apache.http.4_4_1.shade.client.methods.HttpDelete;
import org.apache.http.4_4_1.shade.client.methods.HttpGet;
import org.apache.http.4_4_1.shade.client.methods.HttpHead;
import org.apache.http.4_4_1.shade.client.methods.HttpPatch;
import org.apache.http.4_4_1.shade.client.methods.HttpPost;
import org.apache.http.4_4_1.shade.client.methods.HttpPut;
import org.apache.http.4_4_1.shade.client.methods.HttpRequestBase;
import org.apache.http.4_4_1.shade.entity.BufferedHttpEntity;
import org.apache.http.4_4_1.shade.entity.StringEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpRequestFactory {
    private static final String DEFAULT_ENCODING = "UTF-8";

    HttpRequestFactory() {
    }

    HttpRequestBase createHttpRequest(Request<?> request, ClientConfiguration clientConfiguration, ExecutionContext context) {
        HttpRequestBase httpRequest;
        boolean putParamsInUri;
        URI endpoint = request.getEndpoint();
        String uri = HttpUtils.appendUri(endpoint.toString(), request.getResourcePath(), true);
        String encodedParams = HttpUtils.encodeParameters(request);
        boolean requestHasNoPayload = request.getContent() != null;
        boolean requestIsPost = request.getHttpMethod() == HttpMethodName.POST;
        boolean bl = putParamsInUri = !requestIsPost || requestHasNoPayload;
        if (encodedParams != null && putParamsInUri) {
            uri = uri + "?" + encodedParams;
        }
        if (request.getHttpMethod() == HttpMethodName.POST) {
            HttpPost postMethod = new HttpPost(uri);
            if (request.getContent() == null && encodedParams != null) {
                postMethod.setEntity(this.newStringEntity(encodedParams));
            } else {
                postMethod.setEntity(new RepeatableInputStreamRequestEntity(request));
            }
            httpRequest = postMethod;
        } else if (request.getHttpMethod() == HttpMethodName.PUT) {
            HttpPut putMethod;
            httpRequest = putMethod = new HttpPut(uri);
            putMethod.getParams().setParameter("http.protocol.expect-continue", true);
            if (request.getContent() != null) {
                HttpEntity entity = new RepeatableInputStreamRequestEntity(request);
                if (request.getHeaders().get("Content-Length") == null) {
                    entity = this.newBufferedHttpEntity(entity);
                }
                putMethod.setEntity(entity);
            }
        } else if (request.getHttpMethod() == HttpMethodName.PATCH) {
            HttpPatch patchMethod = new HttpPatch(uri);
            httpRequest = patchMethod;
            if (request.getContent() != null) {
                HttpEntity entity = new RepeatableInputStreamRequestEntity(request);
                if (request.getHeaders().get("Content-Length") == null) {
                    entity = this.newBufferedHttpEntity(entity);
                }
                patchMethod.setEntity(entity);
            }
        } else if (request.getHttpMethod() == HttpMethodName.GET) {
            httpRequest = new HttpGet(uri);
        } else if (request.getHttpMethod() == HttpMethodName.DELETE) {
            httpRequest = new HttpDelete(uri);
        } else if (request.getHttpMethod() == HttpMethodName.HEAD) {
            httpRequest = new HttpHead(uri);
        } else {
            throw new AmazonClientException("Unknown HTTP method name: " + (Object)((Object)request.getHttpMethod()));
        }
        this.configureHeaders(httpRequest, request, context, clientConfiguration);
        return httpRequest;
    }

    private void configureHeaders(HttpRequestBase httpRequest, Request<?> request, ExecutionContext context, ClientConfiguration clientConfiguration) {
        URI endpoint = request.getEndpoint();
        String hostHeader = endpoint.getHost();
        if (HttpUtils.isUsingNonDefaultPort(endpoint)) {
            hostHeader = hostHeader + ":" + endpoint.getPort();
        }
        httpRequest.addHeader("Host", hostHeader);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        if (httpRequest.getHeaders("Content-Type") == null || httpRequest.getHeaders("Content-Type").length == 0) {
            httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.toLowerCase());
        }
        if (context != null && context.getContextUserAgent() != null) {
            httpRequest.addHeader("User-Agent", this.createUserAgentString(clientConfiguration, context.getContextUserAgent()));
        }
    }

    private String createUserAgentString(ClientConfiguration clientConfiguration, String contextUserAgent) {
        if (clientConfiguration.getUserAgent().contains(contextUserAgent)) {
            return clientConfiguration.getUserAgent();
        }
        return clientConfiguration.getUserAgent() + " " + contextUserAgent;
    }

    private HttpEntity newStringEntity(String s) {
        try {
            return new StringEntity(s);
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to create HTTP entity: " + e.getMessage(), e);
        }
    }

    private HttpEntity newBufferedHttpEntity(HttpEntity entity) {
        try {
            return new BufferedHttpEntity(entity);
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to create HTTP entity: " + e.getMessage(), e);
        }
    }
}

