/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1_7_13.shade.http;

import com.amazonaws.1_7_13.shade.AmazonWebServiceClient;
import com.amazonaws.1_7_13.shade.auth.AWSCredentials;
import com.amazonaws.1_7_13.shade.auth.Signer;
import com.amazonaws.1_7_13.shade.handlers.RequestHandler2;
import com.amazonaws.1_7_13.shade.util.AWSRequestMetrics;
import com.amazonaws.1_7_13.shade.util.AWSRequestMetricsFullSupport;
import java.net.URI;
import java.util.List;
import org.apache.http.4_4_1.shade.annotation.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class ExecutionContext {
    private final AWSRequestMetrics awsRequestMetrics;
    private final List<RequestHandler2> requestHandler2s;
    private String contextUserAgent;
    private final AmazonWebServiceClient awsClient;
    private AWSCredentials credentials;

    public ExecutionContext(boolean isMetricEnabled) {
        this(null, isMetricEnabled, null);
    }

    public ExecutionContext() {
        this(null, false, null);
    }

    public ExecutionContext(List<RequestHandler2> requestHandler2s, boolean isMetricEnabled, AmazonWebServiceClient awsClient) {
        this.requestHandler2s = requestHandler2s;
        this.awsRequestMetrics = isMetricEnabled ? new AWSRequestMetricsFullSupport() : new AWSRequestMetrics();
        this.awsClient = awsClient;
    }

    public String getContextUserAgent() {
        return this.contextUserAgent;
    }

    public void setContextUserAgent(String contextUserAgent) {
        this.contextUserAgent = contextUserAgent;
    }

    public List<RequestHandler2> getRequestHandler2s() {
        return this.requestHandler2s;
    }

    public AWSRequestMetrics getAwsRequestMetrics() {
        return this.awsRequestMetrics;
    }

    public void setSigner(Signer signer) {
    }

    public Signer getSignerByURI(URI uri) {
        return this.awsClient == null ? null : this.awsClient.getSignerByURI(uri);
    }

    public AWSCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(AWSCredentials credentials) {
        this.credentials = credentials;
    }
}

