/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.mule.module.s3.simpleapi.SimpleAmazonS3;
import org.mule.module.s3.simpleapi.content.FileS3ObjectContent;
import org.mule.module.s3.simpleapi.content.InputStreamS3ObjectContent;

public final class S3ContentUtils {
    private S3ContentUtils() {
    }

    public static SimpleAmazonS3.S3ObjectContent createContent(Object content, Long contentLength, String contentMd5, String encoding) throws UnsupportedEncodingException {
        if (content instanceof InputStream) {
            InputStream streamContent = (InputStream)content;
            if (contentLength != null) {
                return S3ContentUtils.createContent(streamContent, contentLength, contentMd5);
            }
            Header contentLengthHeader = S3ContentUtils.getContentLengthHeader(content);
            if (contentLengthHeader != null) {
                return S3ContentUtils.createContent(streamContent, Long.parseLong(contentLengthHeader.getValue()), contentMd5);
            }
            return S3ContentUtils.createContent(S3ContentUtils.toTempFile(streamContent));
        }
        if (content instanceof String) {
            return S3ContentUtils.createContent(contentMd5, (String)content, encoding);
        }
        if (content instanceof byte[]) {
            return S3ContentUtils.createContent((byte[])content, contentMd5);
        }
        if (content instanceof File) {
            return S3ContentUtils.createContent((File)content);
        }
        throw new IllegalArgumentException("Wrong input");
    }

    private static File toTempFile(InputStream streamContent) {
        try {
            File tempFile = File.createTempFile("mules3", ".tmp");
            IOUtils.copy((InputStream)streamContent, (OutputStream)new FileOutputStream(tempFile));
            return tempFile;
        }
        catch (IOException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private static SimpleAmazonS3.S3ObjectContent createContent(File content) {
        return new FileS3ObjectContent(content);
    }

    private static Header getContentLengthHeader(Object content) {
        if (content.getClass().getName().equals("org.mule.transport.http.ReleasingInputStream")) {
            return S3ContentUtils.getHttpMethod(content).getResponseHeader("Content-Length");
        }
        return null;
    }

    private static SimpleAmazonS3.S3ObjectContent createContent(byte[] content, String contentMd5) {
        return new InputStreamS3ObjectContent(new ByteArrayInputStream(content), Long.valueOf(content.length), contentMd5);
    }

    private static SimpleAmazonS3.S3ObjectContent createContent(String contentMd5, String stringContent, String encoding) throws UnsupportedEncodingException {
        return new InputStreamS3ObjectContent(new ByteArrayInputStream(stringContent.getBytes()), Long.valueOf(stringContent.getBytes(StringUtils.defaultIfEmpty((String)encoding, (String)"UTF-8")).length), contentMd5);
    }

    private static SimpleAmazonS3.S3ObjectContent createContent(InputStream content, Long contentLength, String contentMd5) {
        return new InputStreamS3ObjectContent(content, contentLength, contentMd5);
    }

    private static HttpMethod getHttpMethod(Object inputStream) {
        try {
            Field field = Class.forName("org.mule.transport.http.ReleasingInputStream").getDeclaredField("method");
            field.setAccessible(true);
            return (HttpMethod)field.get(inputStream);
        }
        catch (Exception e) {
            throw new UnhandledException((Throwable)e);
        }
    }
}

