/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.HttpMethod;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.mule.api.ConnectionException;
import org.mule.module.s3.AccessControlList;
import org.mule.module.s3.S3ContentUtils;
import org.mule.module.s3.StorageClass;
import org.mule.module.s3.simpleapi.ConditionalConstraints;
import org.mule.module.s3.simpleapi.KeyVersion;
import org.mule.module.s3.simpleapi.Region;
import org.mule.module.s3.simpleapi.S3ObjectId;
import org.mule.module.s3.simpleapi.SimpleAmazonS3;
import org.mule.module.s3.simpleapi.SimpleAmazonS3AmazonDevKitImpl;
import org.mule.module.s3.simpleapi.VersioningStatus;
import org.mule.module.s3.util.InternalUtils;

public class S3Connector {
    private String proxyUsername;
    private Integer proxyPort;
    private String proxyPassword;
    private String proxyHost;
    private Integer socketTimeout;
    private Integer connectionTimeout;
    private SimpleAmazonS3 client;

    public Bucket createBucket(String bucketName, Region region, AccessControlList acl) {
        return this.client.createBucket(bucketName, region, acl.toS3Equivalent());
    }

    public void deleteBucket(String bucketName, boolean force) {
        if (force) {
            this.client.deleteBucketAndObjects(bucketName);
        } else {
            this.client.deleteBucket(bucketName);
        }
    }

    public void deleteBucketWebsiteConfiguration(String bucketName) {
        this.client.deleteBucketWebsiteConfiguration(bucketName);
    }

    public String getBucketPolicy(String bucketName) {
        return this.client.getBucketPolicy(bucketName);
    }

    public void setBucketPolicy(String bucketName, String policyText) {
        this.client.setBucketPolicy(bucketName, policyText);
    }

    public void deleteBucketPolicy(String bucketName) {
        this.client.deleteBucketPolicy(bucketName);
    }

    public void setBucketWebsiteConfiguration(String bucketName, BucketWebsiteConfiguration bucketWebsiteConfiguration) {
        this.client.setBucketWebsiteConfiguration(bucketName, bucketWebsiteConfiguration);
    }

    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(String bucketName) {
        return this.client.getBucketWebsiteConfiguration(bucketName);
    }

    public List<Bucket> listBuckets() {
        return this.client.listBuckets();
    }

    public Iterable<S3ObjectSummary> listObjects(String bucketName, String prefix) {
        return this.client.listObjects(bucketName, prefix);
    }

    public Iterable<S3VersionSummary> listObjectVersions(String bucketName) {
        return this.client.listObjectVersions(bucketName);
    }

    public String createObject(String bucketName, String key, Object content, Long contentLength, String contentMd5, String contentType, String contentDisposition, AccessControlList acl, StorageClass storageClass, String encryption, Map<String, String> userMetadata, String encoding) throws UnsupportedEncodingException {
        return this.client.createObject(new S3ObjectId(bucketName, key), S3ContentUtils.createContent(content, contentLength, contentMd5, encoding), contentType, contentDisposition, acl.toS3Equivalent(), storageClass.toS3Equivalent(), encryption, userMetadata);
    }

    public void deleteObject(String bucketName, String key, String versionId) {
        this.client.deleteObject(new S3ObjectId(bucketName, key, versionId));
    }

    public void deleteObjects(String bucketName, List<KeyVersion> keys) {
        this.client.deleteObjects(bucketName, keys);
    }

    public void setObjectStorageClass(String bucketName, String key, StorageClass storageClass) {
        Validate.notNull((Object)((Object)storageClass));
        this.client.setObjectStorageClass(new S3ObjectId(bucketName, key), storageClass.toS3Equivalent());
    }

    public String copyObject(String sourceBucketName, String sourceKey, String sourceVersionId, String destinationBucketName, String destinationKey, AccessControlList destinationAcl, StorageClass destinationStorageClass, Map<String, String> destinationUserMetadata, Date modifiedSince, Date unmodifiedSince, String encryption) {
        return this.client.copyObject(new S3ObjectId(sourceBucketName, sourceKey, sourceVersionId), new S3ObjectId(InternalUtils.coalesce(destinationBucketName, sourceBucketName), destinationKey), ConditionalConstraints.from(modifiedSince, unmodifiedSince), destinationAcl.toS3Equivalent(), destinationStorageClass.toS3Equivalent(), encryption, destinationUserMetadata);
    }

    public URI createObjectPresignedUri(String bucketName, String key, String versionId, Date expiration, String method) {
        return this.client.createObjectPresignedUri(new S3ObjectId(bucketName, key, versionId), expiration, this.toHttpMethod(method));
    }

    private HttpMethod toHttpMethod(String method) {
        return method != null ? HttpMethod.valueOf((String)method) : null;
    }

    public S3ObjectInputStream getObjectContent(String bucketName, String key, String versionId, Date modifiedSince, Date unmodifiedSince) {
        return this.client.getObjectContent(new S3ObjectId(bucketName, key, versionId), ConditionalConstraints.from(modifiedSince, unmodifiedSince));
    }

    public S3Object getObject(String bucketName, String key, String versionId, Date modifiedSince, Date unmodifiedSince) {
        return this.client.getObject(new S3ObjectId(bucketName, key, versionId), ConditionalConstraints.from(modifiedSince, unmodifiedSince));
    }

    public ObjectMetadata getObjectMetadata(String bucketName, String key, String versionId) {
        return this.client.getObjectMetadata(new S3ObjectId(bucketName, key, versionId));
    }

    public void setBucketVersioningStatus(String bucketName, VersioningStatus versioningStatus) {
        this.client.setBucketVersioningStatus(bucketName, versioningStatus);
    }

    public BucketVersioningConfiguration getBucketVersioningConfiguration(String bucketName) {
        return this.client.getBucketVersioningConfiguration(bucketName);
    }

    public URI createObjectUri(String bucketName, String key, boolean useDefaultServer, boolean secure) {
        if (useDefaultServer) {
            return this.client.createObjectUriUsingDefaultServer(new S3ObjectId(bucketName, key), secure);
        }
        return this.client.createObjectUri(new S3ObjectId(bucketName, key), secure);
    }

    public synchronized void connect(String accessKey, String secretKey) throws ConnectionException {
        if (this.client == null) {
            this.client = new SimpleAmazonS3AmazonDevKitImpl(this.createAmazonS3(accessKey, secretKey));
        }
    }

    public synchronized void disconnect() {
        if (this.client != null) {
            this.client = null;
        }
    }

    public boolean isConnected() {
        return this.client != null;
    }

    public String connectionId() {
        return "unknown";
    }

    private AmazonS3 createAmazonS3(String accessKey, String secretKey) {
        ClientConfiguration clientConfig = new ClientConfiguration();
        if (this.proxyUsername != null) {
            clientConfig.setProxyUsername(this.proxyUsername);
        }
        if (this.proxyPort != null) {
            clientConfig.setProxyPort(this.proxyPort.intValue());
        }
        if (this.proxyPassword != null) {
            clientConfig.setProxyPassword(this.proxyPassword);
        }
        if (this.proxyHost != null) {
            clientConfig.setProxyHost(this.proxyHost);
        }
        if (this.connectionTimeout != null) {
            clientConfig.setConnectionTimeout(this.connectionTimeout.intValue());
        }
        if (this.socketTimeout != null) {
            clientConfig.setSocketTimeout(this.socketTimeout.intValue());
        }
        return new AmazonS3Client(this.createCredentials(accessKey, secretKey), clientConfig);
    }

    private AWSCredentials createCredentials(String accessKey, String secretKey) {
        if (StringUtils.isEmpty((String)accessKey) && StringUtils.isEmpty((String)secretKey)) {
            return null;
        }
        return new BasicAWSCredentials(accessKey, secretKey);
    }

    public void setClient(SimpleAmazonS3 client) {
        this.client = client;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }
}

