/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.simpleapi;

import com.amazonaws.AmazonClientException;
import com.amazonaws.HttpMethod;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.VersionListing;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.mule.module.s3.simpleapi.ConditionalConstraints;
import org.mule.module.s3.simpleapi.KeyVersion;
import org.mule.module.s3.simpleapi.Region;
import org.mule.module.s3.simpleapi.S3ObjectId;
import org.mule.module.s3.simpleapi.SimpleAmazonS3;
import org.mule.module.s3.simpleapi.VersioningStatus;

public class SimpleAmazonS3AmazonDevKitImpl
implements SimpleAmazonS3 {
    private final AmazonS3 s3;

    public SimpleAmazonS3AmazonDevKitImpl(@NotNull AmazonS3 s3) {
        Validate.notNull((Object)s3);
        this.s3 = s3;
    }

    @Override
    public List<Bucket> listBuckets() {
        return this.s3.listBuckets();
    }

    @Override
    public Bucket createBucket(@NotNull String bucketName, Region region, CannedAccessControlList acl) {
        Validate.notNull((Object)bucketName);
        CreateBucketRequest request = new CreateBucketRequest(bucketName, region.toS3Equivalent());
        request.setCannedAcl(acl);
        return this.s3.createBucket(request);
    }

    @Override
    public void deleteBucket(@NotNull String bucketName) {
        Validate.notNull((Object)bucketName);
        this.s3.deleteBucket(bucketName);
    }

    @Override
    public void deleteBucketAndObjects(@NotNull String bucketName) {
        Validate.notNull((Object)bucketName);
        if (!this.s3.getBucketVersioningConfiguration(bucketName).getStatus().equals("Off")) {
            for (S3VersionSummary summary : this.listObjectVersions(bucketName)) {
                this.s3.deleteVersion(bucketName, summary.getKey(), summary.getVersionId());
            }
        } else {
            for (S3ObjectSummary summary : this.listObjects(bucketName, null)) {
                this.s3.deleteObject(bucketName, summary.getKey());
            }
        }
        this.deleteBucket(bucketName);
    }

    public S3VersionSummaryIterable listObjectVersions(@NotNull String bucketName) {
        Validate.notEmpty((String)bucketName);
        return new S3VersionSummaryIterable(bucketName);
    }

    @Override
    public Iterable<S3ObjectSummary> listObjects(@NotNull String bucketName, String prefix) {
        Validate.notNull((Object)bucketName);
        return new S3ObjectSummaryIterable(bucketName, prefix);
    }

    @Override
    public void deleteBucketPolicy(@NotNull String bucketName) {
        Validate.notNull((Object)bucketName);
        this.s3.deleteBucketPolicy(bucketName);
    }

    @Override
    public String getBucketPolicy(@NotNull String bucketName) {
        Validate.notNull((Object)bucketName);
        return this.s3.getBucketPolicy(bucketName).getPolicyText();
    }

    @Override
    public void setBucketPolicy(@NotNull String bucketName, @NotNull String policyText) {
        Validate.notNull((Object)bucketName);
        Validate.notNull((Object)policyText);
        this.s3.setBucketPolicy(bucketName, policyText);
    }

    @Override
    public void deleteBucketWebsiteConfiguration(@NotNull String bucketName) {
        Validate.notNull((Object)bucketName);
        this.s3.deleteBucketWebsiteConfiguration(bucketName);
    }

    @Override
    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(@NotNull String bucketName) {
        Validate.notNull((Object)bucketName);
        return this.s3.getBucketWebsiteConfiguration(bucketName);
    }

    @Override
    public void setBucketWebsiteConfiguration(@NotNull String bucketName, @NotNull BucketWebsiteConfiguration configuration) {
        Validate.notNull((Object)bucketName);
        Validate.notNull((Object)configuration);
        Validate.notNull((Object)configuration.getIndexDocumentSuffix());
        this.s3.setBucketWebsiteConfiguration(bucketName, configuration);
    }

    @Override
    public String createObject(@NotNull S3ObjectId objectId, @NotNull SimpleAmazonS3.S3ObjectContent content, String contentType, String contentDisposition, CannedAccessControlList acl, StorageClass storageClass, Map<String, String> userMetadata, String encryption) {
        Validate.notNull((Object)content);
        PutObjectRequest request = content.createPutObjectRequest();
        if (request.getMetadata() != null) {
            request.getMetadata().setContentType(contentType);
            if (StringUtils.isNotBlank((String)contentDisposition)) {
                request.getMetadata().setContentDisposition(contentDisposition);
            }
            if (encryption != null) {
                request.getMetadata().setServerSideEncryption(encryption);
            }
        }
        request.getMetadata().setUserMetadata(userMetadata);
        request.setBucketName(objectId.getBucketName());
        request.setKey(objectId.getKey());
        request.setCannedAcl(acl);
        if (storageClass != null) {
            request.setStorageClass(storageClass);
        }
        return this.s3.putObject(request).getVersionId();
    }

    @Override
    public void deleteObject(@NotNull S3ObjectId objectId) {
        Validate.notNull((Object)objectId);
        if (objectId.isVersioned()) {
            this.s3.deleteVersion(objectId.getBucketName(), objectId.getKey(), objectId.getVersionId());
        } else {
            this.s3.deleteObject(objectId.getBucketName(), objectId.getKey());
        }
    }

    @Override
    public void deleteObjects(@NotNull String bucketName, @NotNull List<KeyVersion> keys) {
        Validate.notNull((Object)bucketName);
        Validate.notNull(keys);
        Validate.notEmpty(keys);
        DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucketName);
        ArrayList<DeleteObjectsRequest.KeyVersion> deleteKeysRequest = new ArrayList<DeleteObjectsRequest.KeyVersion>();
        for (KeyVersion key : keys) {
            deleteKeysRequest.add(new DeleteObjectsRequest.KeyVersion(key.getValue(), key.getVersion()));
        }
        deleteObjectsRequest.setKeys(deleteKeysRequest);
        this.s3.deleteObjects(deleteObjectsRequest);
    }

    @Override
    public String copyObject(@NotNull S3ObjectId source, @NotNull S3ObjectId destination, @NotNull ConditionalConstraints conditionalConstraints, CannedAccessControlList acl, StorageClass storageClass, Map<String, String> userMetadata, String encryption) {
        Validate.notNull((Object)source);
        Validate.notNull((Object)destination);
        Validate.notNull((Object)conditionalConstraints);
        CopyObjectRequest request = new CopyObjectRequest(source.getBucketName(), source.getKey(), source.getVersionId(), destination.getBucketName(), destination.getKey());
        request.setCannedAccessControlList(acl);
        if (storageClass != null) {
            request.setStorageClass(storageClass);
        }
        if (encryption != null) {
            request.setNewObjectMetadata(new ObjectMetadata());
            request.getNewObjectMetadata().setServerSideEncryption(encryption);
            if (userMetadata != null) {
                request.getNewObjectMetadata().setUserMetadata(userMetadata);
            }
        } else if (userMetadata != null) {
            request.setNewObjectMetadata(new ObjectMetadata());
            request.getNewObjectMetadata().setUserMetadata(userMetadata);
        }
        conditionalConstraints.populate(request);
        return this.s3.copyObject(request).getVersionId();
    }

    @Override
    public URI createObjectPresignedUri(@NotNull S3ObjectId objectId, Date expiration, HttpMethod method) {
        Validate.notNull((Object)objectId);
        try {
            return this.s3.generatePresignedUrl(objectId.getBucketName(), objectId.getKey(), expiration, method).toURI();
        }
        catch (URISyntaxException e) {
            throw new AmazonClientException("S3 returned a malformed URI", (Throwable)e);
        }
    }

    @Override
    public void setObjectStorageClass(@NotNull S3ObjectId objectId, StorageClass newStorageClass) {
        this.s3.changeObjectStorageClass(objectId.getBucketName(), objectId.getKey(), newStorageClass);
    }

    @Override
    public S3ObjectInputStream getObjectContent(@NotNull S3ObjectId objectId, @NotNull ConditionalConstraints conditionalConstraints) {
        Validate.notNull((Object)objectId);
        S3Object object = this.getObject(objectId, conditionalConstraints);
        if (object == null) {
            return null;
        }
        return object.getObjectContent();
    }

    @Override
    @NotNull
    public ObjectMetadata getObjectMetadata(@NotNull S3ObjectId objectId) {
        Validate.notNull((Object)objectId);
        return this.s3.getObjectMetadata(new GetObjectMetadataRequest(objectId.getBucketName(), objectId.getKey(), objectId.getVersionId()));
    }

    @Override
    public S3Object getObject(@NotNull S3ObjectId objectId, @NotNull ConditionalConstraints conditionalConstraints) {
        Validate.notNull((Object)objectId);
        GetObjectRequest request = new GetObjectRequest(objectId.getBucketName(), objectId.getKey(), objectId.getVersionId());
        conditionalConstraints.populate(request);
        return this.s3.getObject(request);
    }

    @Override
    public void setBucketVersioningStatus(@NotNull String bucketName, @NotNull VersioningStatus versioningStatus) {
        Validate.notNull((Object)bucketName);
        this.s3.setBucketVersioningConfiguration(new SetBucketVersioningConfigurationRequest(bucketName, new BucketVersioningConfiguration(versioningStatus.toString())));
    }

    @Override
    public URI createObjectUriUsingDefaultServer(S3ObjectId objectId, boolean secure) {
        Validate.notNull((Object)objectId);
        return Region.getDefaultRegion().getObjectUri(objectId, secure);
    }

    @Override
    public URI createObjectUri(S3ObjectId objectId, boolean secure) {
        Validate.notNull((Object)objectId);
        String location = this.s3.getBucketLocation(objectId.getBucketName());
        return Region.from(location).getObjectUri(objectId, secure);
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(@NotNull String bucketName) {
        Validate.notNull((Object)bucketName);
        return this.s3.getBucketVersioningConfiguration(bucketName);
    }

    private abstract class S3SummaryIterable<SummaryType, ListingType>
    extends AbstractCollection<SummaryType>
    implements Iterable<SummaryType> {
        private S3SummaryIterable() {
        }

        @Override
        public Iterator<SummaryType> iterator() {
            final ListingType summaryListing = this.listSummaries();
            return new Iterator<SummaryType>(){
                private ListingType currentList;
                private Iterator<SummaryType> currentIter;
                {
                    this.currentList = summaryListing;
                    this.currentIter = S3SummaryIterable.this.getSummariesIterator(summaryListing);
                }

                @Override
                public boolean hasNext() {
                    this.updateIter();
                    return this.currentIter.hasNext();
                }

                @Override
                public SummaryType next() {
                    this.updateIter();
                    return this.currentIter.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private void updateIter() {
                    if (!this.currentIter.hasNext() && S3SummaryIterable.this.isTruncated(this.currentList)) {
                        this.currentList = S3SummaryIterable.this.listNext(this.currentList);
                        this.currentIter = S3SummaryIterable.this.getSummariesIterator(this.currentList);
                    }
                }
            };
        }

        protected abstract ListingType listNext(ListingType var1);

        protected abstract boolean isTruncated(ListingType var1);

        protected abstract ListingType listSummaries();

        protected abstract Iterator<SummaryType> getSummariesIterator(ListingType var1);

        @Override
        public Object[] toArray() {
            LinkedList<SummaryType> l = new LinkedList<SummaryType>();
            for (SummaryType o : this) {
                l.add(o);
            }
            return l.toArray();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }
    }

    private class S3VersionSummaryIterable
    extends S3SummaryIterable<S3VersionSummary, VersionListing> {
        private String bucketName;

        public S3VersionSummaryIterable(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        protected Iterator<S3VersionSummary> getSummariesIterator(VersionListing summaryListing) {
            return summaryListing.getVersionSummaries().iterator();
        }

        @Override
        protected boolean isTruncated(VersionListing summaryListing) {
            return summaryListing.isTruncated();
        }

        @Override
        protected VersionListing listNext(VersionListing currentList) {
            return SimpleAmazonS3AmazonDevKitImpl.this.s3.listNextBatchOfVersions(currentList);
        }

        @Override
        protected VersionListing listSummaries() {
            return SimpleAmazonS3AmazonDevKitImpl.this.s3.listVersions(this.bucketName, null);
        }
    }

    private class S3ObjectSummaryIterable
    extends S3SummaryIterable<S3ObjectSummary, ObjectListing> {
        private String bucketName;
        private String prefix;

        public S3ObjectSummaryIterable(String bucketName, String prefix) {
            this.bucketName = bucketName;
            this.prefix = prefix;
        }

        @Override
        protected Iterator<S3ObjectSummary> getSummariesIterator(ObjectListing summaryListing) {
            return summaryListing.getObjectSummaries().iterator();
        }

        @Override
        protected boolean isTruncated(ObjectListing summaryListing) {
            return summaryListing.isTruncated();
        }

        @Override
        protected ObjectListing listNext(ObjectListing currentList) {
            return SimpleAmazonS3AmazonDevKitImpl.this.s3.listNextBatchOfObjects(currentList);
        }

        @Override
        protected ObjectListing listSummaries() {
            return SimpleAmazonS3AmazonDevKitImpl.this.s3.listObjects(this.bucketName, this.prefix);
        }
    }
}

