/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.config;

import org.mule.config.PoolingProfile;
import org.mule.module.s3.connectivity.S3ConnectorConnectionManager;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class S3ConnectorConfigDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.parseConfigName(element);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)S3ConnectorConnectionManager.class.getName());
        builder.setScope("singleton");
        this.setInitMethodIfNeeded(builder, S3ConnectorConnectionManager.class);
        this.setDestroyMethodIfNeeded(builder, S3ConnectorConnectionManager.class);
        this.parseProperty(builder, element, "proxyUsername", "proxyUsername");
        this.parseProperty(builder, element, "proxyPort", "proxyPort");
        this.parseProperty(builder, element, "proxyPassword", "proxyPassword");
        this.parseProperty(builder, element, "proxyHost", "proxyHost");
        this.parseProperty(builder, element, "socketTimeout", "socketTimeout");
        this.parseProperty(builder, element, "connectionTimeout", "connectionTimeout");
        this.parseProperty(builder, element, "accessKey", "accessKey");
        this.parseProperty(builder, element, "secretKey", "secretKey");
        BeanDefinitionBuilder connectionPoolingProfileBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)PoolingProfile.class.getName());
        Element connectionPoolingProfileElement = DomUtils.getChildElementByTagName((Element)element, (String)"connection-pooling-profile");
        if (connectionPoolingProfileElement != null) {
            this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "maxActive");
            this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "maxIdle");
            this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "maxWait");
            if (this.hasAttribute(connectionPoolingProfileElement, "exhaustedAction")) {
                connectionPoolingProfileBuilder.addPropertyValue("exhaustedAction", PoolingProfile.POOL_EXHAUSTED_ACTIONS.get(connectionPoolingProfileElement.getAttribute("exhaustedAction")));
            }
            if (this.hasAttribute(connectionPoolingProfileElement, "initialisationPolicy")) {
                connectionPoolingProfileBuilder.addPropertyValue("initialisationPolicy", PoolingProfile.POOL_INITIALISATION_POLICIES.get(connectionPoolingProfileElement.getAttribute("initialisationPolicy")));
            }
            if (this.hasAttribute(connectionPoolingProfileElement, "evictionCheckIntervalMillis")) {
                this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "evictionCheckIntervalMillis");
            }
            if (this.hasAttribute(connectionPoolingProfileElement, "minEvictionMillis")) {
                this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "minEvictionMillis");
            }
            builder.addPropertyValue("connectionPoolingProfile", (Object)connectionPoolingProfileBuilder.getBeanDefinition());
        }
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.parseRetryPolicyTemplate("reconnect", element, parserContext, builder, (BeanDefinition)definition);
        this.parseRetryPolicyTemplate("reconnect-forever", element, parserContext, builder, (BeanDefinition)definition);
        this.parseRetryPolicyTemplate("reconnect-custom-strategy", element, parserContext, builder, (BeanDefinition)definition);
        return definition;
    }
}

