/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.module.s3.adapters.S3ConnectorConnectionIdentifierAdapter;
import org.mule.module.s3.connectivity.S3ConnectorConnectionKey;
import org.mule.module.s3.connectivity.S3ConnectorConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(S3ConnectorConnectionFactory.class);
    private S3ConnectorConnectionManager connectionManager;

    public S3ConnectorConnectionFactory(S3ConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof S3ConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.module.s3.connectivity.S3ConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        S3ConnectorConnectionIdentifierAdapter connector = new S3ConnectorConnectionIdentifierAdapter();
        connector.setProxyUsername(this.connectionManager.getProxyUsername());
        connector.setProxyPort(this.connectionManager.getProxyPort());
        connector.setProxyPassword(this.connectionManager.getProxyPassword());
        connector.setProxyHost(this.connectionManager.getProxyHost());
        connector.setSocketTimeout(this.connectionManager.getSocketTimeout());
        connector.setConnectionTimeout(this.connectionManager.getConnectionTimeout());
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        if (!connector.isConnected()) {
            connector.connect(((S3ConnectorConnectionKey)key).getAccessKey(), ((S3ConnectorConnectionKey)key).getSecretKey());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof S3ConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.module.s3.connectivity.S3ConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof S3ConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.module.s3.adapters.S3ConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((S3ConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((S3ConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((S3ConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof S3ConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.module.s3.adapters.S3ConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((S3ConnectorConnectionIdentifierAdapter)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof S3ConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof S3ConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((S3ConnectorConnectionIdentifierAdapter)obj).isConnected()) {
            ((S3ConnectorConnectionIdentifierAdapter)obj).connect(((S3ConnectorConnectionKey)key).getAccessKey(), ((S3ConnectorConnectionKey)key).getSecretKey());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

