/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.simpleapi;

import javax.validation.constraints.NotNull;
import org.apache.commons.lang.Validate;

public class S3ObjectId {
    private final String bucketName;
    private final String key;
    private final String versionId;

    public S3ObjectId(@NotNull String bucketName, @NotNull String key) {
        this(bucketName, key, null);
    }

    public S3ObjectId(@NotNull String bucketName, @NotNull String key, String versionId) {
        Validate.notEmpty((String)bucketName);
        Validate.notEmpty((String)key);
        if (versionId != null) {
            Validate.notEmpty((String)versionId);
        }
        this.bucketName = bucketName;
        this.key = key;
        this.versionId = versionId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKey() {
        return this.key;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public boolean isVersioned() {
        return this.versionId != null;
    }
}

