/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.HttpMethod;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.mule.api.ConnectionException;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.api.annotations.param.Payload;
import org.mule.module.s3.AccessControlList;
import org.mule.module.s3.S3ContentUtils;
import org.mule.module.s3.StorageClass;
import org.mule.module.s3.simpleapi.ConditionalConstraints;
import org.mule.module.s3.simpleapi.Region;
import org.mule.module.s3.simpleapi.S3ObjectId;
import org.mule.module.s3.simpleapi.SimpleAmazonS3;
import org.mule.module.s3.simpleapi.SimpleAmazonS3AmazonDevKitImpl;
import org.mule.module.s3.simpleapi.VersioningStatus;
import org.mule.module.s3.util.InternalUtils;

@Connector(name="s3", schemaVersion="2.0", friendlyName="Amazon S3", minMuleVersion="3.4")
public class S3Connector {
    @Configurable
    @Optional
    private String proxyUsername;
    @Configurable
    @Optional
    private Integer proxyPort;
    @Configurable
    @Optional
    private String proxyPassword;
    @Configurable
    @Optional
    private String proxyHost;
    private SimpleAmazonS3 client;

    @Processor
    public Bucket createBucket(String bucketName, @Optional @Default(value="US_STANDARD") Region region, @Optional @Default(value="PRIVATE") AccessControlList acl) {
        return this.client.createBucket(bucketName, region, acl.toS3Equivalent());
    }

    @Processor
    public void deleteBucket(String bucketName, @Optional @Default(value="false") boolean force) {
        if (force) {
            this.client.deleteBucketAndObjects(bucketName);
        } else {
            this.client.deleteBucket(bucketName);
        }
    }

    @Processor
    public void deleteBucketWebsiteConfiguration(String bucketName) {
        this.client.deleteBucketWebsiteConfiguration(bucketName);
    }

    @Processor
    public String getBucketPolicy(String bucketName) {
        return this.client.getBucketPolicy(bucketName);
    }

    @Processor
    public void setBucketPolicy(String bucketName, String policyText) {
        this.client.setBucketPolicy(bucketName, policyText);
    }

    @Processor
    public void deleteBucketPolicy(String bucketName) {
        this.client.deleteBucketPolicy(bucketName);
    }

    @Processor
    public void setBucketWebsiteConfiguration(String bucketName, String suffix, @Optional String errorDocument) {
        this.client.setBucketWebsiteConfiguration(bucketName, errorDocument != null ? new BucketWebsiteConfiguration(suffix, errorDocument) : new BucketWebsiteConfiguration(suffix));
    }

    @Processor
    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(String bucketName) {
        return this.client.getBucketWebsiteConfiguration(bucketName);
    }

    @Processor
    public List<Bucket> listBuckets() {
        return this.client.listBuckets();
    }

    @Processor
    public Iterable<S3ObjectSummary> listObjects(String bucketName, @Optional String prefix) {
        return this.client.listObjects(bucketName, prefix);
    }

    @Processor
    public Iterable<S3VersionSummary> listObjectVersions(String bucketName) {
        return this.client.listObjectVersions(bucketName);
    }

    @Processor
    public String createObject(String bucketName, String key, @Payload Object content, @Optional Long contentLength, @Optional String contentMd5, @Optional String contentType, @Optional String contentDisposition, @Optional @Default(value="PRIVATE") AccessControlList acl, @Optional @Default(value="STANDARD") StorageClass storageClass, @Optional Map<String, String> userMetadata) {
        return this.client.createObject(new S3ObjectId(bucketName, key), S3ContentUtils.createContent(content, contentLength, contentMd5), contentType, contentDisposition, acl.toS3Equivalent(), storageClass.toS3Equivalent(), userMetadata);
    }

    @Processor
    public void deleteObject(String bucketName, String key, @Optional String versionId) {
        this.client.deleteObject(new S3ObjectId(bucketName, key, versionId));
    }

    @Processor
    public void setObjectStorageClass(String bucketName, String key, StorageClass storageClass) {
        Validate.notNull((Object)((Object)storageClass));
        this.client.setObjectStorageClass(new S3ObjectId(bucketName, key), storageClass.toS3Equivalent());
    }

    @Processor
    public String copyObject(String sourceBucketName, String sourceKey, @Optional String sourceVersionId, @Optional String destinationBucketName, String destinationKey, @Optional @Default(value="PRIVATE") AccessControlList destinationAcl, @Optional @Default(value="STANDARD") StorageClass destinationStorageClass, @Optional Map<String, String> destinationUserMetadata, @Optional Date modifiedSince, @Optional Date unmodifiedSince) {
        return this.client.copyObject(new S3ObjectId(sourceBucketName, sourceKey, sourceVersionId), new S3ObjectId(InternalUtils.coalesce(destinationBucketName, sourceBucketName), destinationKey), ConditionalConstraints.from(modifiedSince, unmodifiedSince), destinationAcl.toS3Equivalent(), destinationStorageClass.toS3Equivalent(), destinationUserMetadata);
    }

    @Processor
    public URI createObjectPresignedUri(String bucketName, String key, @Optional String versionId, @Optional Date expiration, @Optional @Default(value="PUT") String method) {
        return this.client.createObjectPresignedUri(new S3ObjectId(bucketName, key, versionId), expiration, this.toHttpMethod(method));
    }

    private HttpMethod toHttpMethod(String method) {
        return method != null ? HttpMethod.valueOf((String)method) : null;
    }

    @Processor
    public InputStream getObjectContent(String bucketName, String key, @Optional String versionId, @Optional Date modifiedSince, @Optional Date unmodifiedSince) {
        return this.client.getObjectContent(new S3ObjectId(bucketName, key, versionId), ConditionalConstraints.from(modifiedSince, unmodifiedSince));
    }

    @Processor
    public S3Object getObject(String bucketName, String key, @Optional String versionId, @Optional Date modifiedSince, @Optional Date unmodifiedSince) {
        return this.client.getObject(new S3ObjectId(bucketName, key, versionId), ConditionalConstraints.from(modifiedSince, unmodifiedSince));
    }

    @Processor
    public ObjectMetadata getObjectMetadata(String bucketName, String key, @Optional String versionId) {
        return this.client.getObjectMetadata(new S3ObjectId(bucketName, key, versionId));
    }

    @Processor
    public void setBucketVersioningStatus(String bucketName, VersioningStatus versioningStatus) {
        this.client.setBucketVersioningStatus(bucketName, versioningStatus);
    }

    @Processor
    public URI createObjectUri(String bucketName, String key, @Optional @Default(value="false") boolean useDefaultServer, @Optional @Default(value="false") boolean secure) {
        if (useDefaultServer) {
            return this.client.createObjectUriUsingDefaultServer(new S3ObjectId(bucketName, key), secure);
        }
        return this.client.createObjectUri(new S3ObjectId(bucketName, key), secure);
    }

    @Connect
    public synchronized void connect(@ConnectionKey String accessKey, String secretKey) throws ConnectionException {
        if (this.client == null) {
            this.client = new SimpleAmazonS3AmazonDevKitImpl(this.createAmazonS3(accessKey, secretKey));
        }
    }

    @Disconnect
    public synchronized void disconnect() {
        if (this.client != null) {
            this.client = null;
        }
    }

    @ValidateConnection
    public boolean isConnected() {
        return this.client != null;
    }

    @ConnectionIdentifier
    public String connectionId() {
        return "unknown";
    }

    private AmazonS3 createAmazonS3(String accessKey, String secretKey) {
        ClientConfiguration clientConfig = new ClientConfiguration();
        if (this.proxyUsername != null) {
            clientConfig.setProxyUsername(this.proxyUsername);
        }
        if (this.proxyPort != null) {
            clientConfig.setProxyPort(this.proxyPort.intValue());
        }
        if (this.proxyPassword != null) {
            clientConfig.setProxyPassword(this.proxyPassword);
        }
        if (this.proxyHost != null) {
            clientConfig.setProxyHost(this.proxyHost);
        }
        return new AmazonS3Client(this.createCredentials(accessKey, secretKey), clientConfig);
    }

    private AWSCredentials createCredentials(String accessKey, String secretKey) {
        if (StringUtils.isEmpty((String)accessKey) && StringUtils.isEmpty((String)secretKey)) {
            return null;
        }
        return new BasicAWSCredentials(accessKey, secretKey);
    }

    public void setClient(SimpleAmazonS3 client) {
        this.client = client;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }
}

