
package org.mule.module.s3.processors;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.common.DefaultResult;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataModel;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.s3.AccessControlList;
import org.mule.module.s3.S3Connector;
import org.mule.module.s3.StorageClass;
import org.mule.module.s3.connectivity.S3ConnectorConnectionManager;


/**
 * CreateObjectMessageProcessor invokes the {@link org.mule.module.s3.S3Connector#createObject(java.lang.String, java.lang.String, java.lang.Object, java.lang.Long, java.lang.String, java.lang.String, java.lang.String, org.mule.module.s3.AccessControlList, org.mule.module.s3.StorageClass, java.util.Map)} method in {@link S3Connector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0-RC1", date = "2013-02-18T07:53:52-03:00", comments = "Build master.1476.47e461c")
public class CreateObjectMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor, OperationMetaDataEnabled
{

    protected Object bucketName;
    protected String _bucketNameType;
    protected Object key;
    protected String _keyType;
    protected Object content;
    protected Object _contentType;
    protected Object contentLength;
    protected Long _contentLengthType;
    protected Object contentMd5;
    protected String _contentMd5Type;
    protected Object contentType;
    protected String _contentTypeType;
    protected Object contentDisposition;
    protected String _contentDispositionType;
    protected Object acl;
    protected AccessControlList _aclType;
    protected Object storageClass;
    protected StorageClass _storageClassType;
    protected Object userMetadata;
    protected Map<String, String> _userMetadataType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets content
     * 
     * @param value Value to set
     */
    public void setContent(Object value) {
        this.content = value;
    }

    /**
     * Sets storageClass
     * 
     * @param value Value to set
     */
    public void setStorageClass(Object value) {
        this.storageClass = value;
    }

    /**
     * Sets acl
     * 
     * @param value Value to set
     */
    public void setAcl(Object value) {
        this.acl = value;
    }

    /**
     * Sets userMetadata
     * 
     * @param value Value to set
     */
    public void setUserMetadata(Object value) {
        this.userMetadata = value;
    }

    /**
     * Sets contentType
     * 
     * @param value Value to set
     */
    public void setContentType(Object value) {
        this.contentType = value;
    }

    /**
     * Sets contentMd5
     * 
     * @param value Value to set
     */
    public void setContentMd5(Object value) {
        this.contentMd5 = value;
    }

    /**
     * Sets contentDisposition
     * 
     * @param value Value to set
     */
    public void setContentDisposition(Object value) {
        this.contentDisposition = value;
    }

    /**
     * Sets contentLength
     * 
     * @param value Value to set
     */
    public void setContentLength(Object value) {
        this.contentLength = value;
    }

    /**
     * Sets bucketName
     * 
     * @param value Value to set
     */
    public void setBucketName(Object value) {
        this.bucketName = value;
    }

    /**
     * Sets key
     * 
     * @param value Value to set
     */
    public void setKey(Object value) {
        this.key = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(S3ConnectorConnectionManager.class, true, event);
            final String _transformedBucketName = ((String) evaluateAndTransform(getMuleContext(), event, CreateObjectMessageProcessor.class.getDeclaredField("_bucketNameType").getGenericType(), null, bucketName));
            final String _transformedKey = ((String) evaluateAndTransform(getMuleContext(), event, CreateObjectMessageProcessor.class.getDeclaredField("_keyType").getGenericType(), null, key));
            final Object _transformedContent = ((Object) evaluateAndTransform(getMuleContext(), event, CreateObjectMessageProcessor.class.getDeclaredField("_contentType").getGenericType(), null, "#[payload]"));
            final Long _transformedContentLength = ((Long) evaluateAndTransform(getMuleContext(), event, CreateObjectMessageProcessor.class.getDeclaredField("_contentLengthType").getGenericType(), null, contentLength));
            final String _transformedContentMd5 = ((String) evaluateAndTransform(getMuleContext(), event, CreateObjectMessageProcessor.class.getDeclaredField("_contentMd5Type").getGenericType(), null, contentMd5));
            final String _transformedContentType = ((String) evaluateAndTransform(getMuleContext(), event, CreateObjectMessageProcessor.class.getDeclaredField("_contentTypeType").getGenericType(), null, contentType));
            final String _transformedContentDisposition = ((String) evaluateAndTransform(getMuleContext(), event, CreateObjectMessageProcessor.class.getDeclaredField("_contentDispositionType").getGenericType(), null, contentDisposition));
            final AccessControlList _transformedAcl = ((AccessControlList) evaluateAndTransform(getMuleContext(), event, CreateObjectMessageProcessor.class.getDeclaredField("_aclType").getGenericType(), null, acl));
            final StorageClass _transformedStorageClass = ((StorageClass) evaluateAndTransform(getMuleContext(), event, CreateObjectMessageProcessor.class.getDeclaredField("_storageClassType").getGenericType(), null, storageClass));
            final Map<String, String> _transformedUserMetadata = ((Map<String, String> ) evaluateAndTransform(getMuleContext(), event, CreateObjectMessageProcessor.class.getDeclaredField("_userMetadataType").getGenericType(), null, userMetadata));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((S3Connector) object).createObject(_transformedBucketName, _transformedKey, _transformedContent, _transformedContentLength, _transformedContentMd5, _transformedContentType, _transformedContentDisposition, _transformedAcl, _transformedStorageClass, _transformedUserMetadata);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("createObject"), event, e);
        }
    }

    @Override
    public Result<MetaData> getInputMetaData() {
        return new DefaultResult<MetaData>(null, (Result.Status.SUCCESS));
    }

    @Override
    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult<MetaData>(new DefaultMetaData(getPojoOrSimpleModel(String.class)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals(dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        } else {
            return new DefaultMetaDataModel(dataType);
        }
    }

}
