/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAttributesRequestMarshaller
implements Marshaller<Request<DeleteAttributesRequest>, DeleteAttributesRequest> {
    @Override
    public Request<DeleteAttributesRequest> marshall(DeleteAttributesRequest deleteAttributesRequest) {
        DefaultRequest<DeleteAttributesRequest> request = new DefaultRequest<DeleteAttributesRequest>(deleteAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "DeleteAttributes");
        request.addParameter("Version", "2009-04-15");
        if (deleteAttributesRequest != null && deleteAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(deleteAttributesRequest.getDomainName()));
        }
        if (deleteAttributesRequest != null && deleteAttributesRequest.getItemName() != null) {
            request.addParameter("ItemName", StringUtils.fromString(deleteAttributesRequest.getItemName()));
        }
        if (deleteAttributesRequest != null) {
            List<Attribute> attributesList = deleteAttributesRequest.getAttributes();
            int attributesListIndex = 1;
            for (Attribute attributesListValue : attributesList) {
                if (attributesListValue != null && attributesListValue.getName() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Name", StringUtils.fromString(attributesListValue.getName()));
                }
                if (attributesListValue != null && attributesListValue.getAlternateNameEncoding() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".AlternateNameEncoding", StringUtils.fromString(attributesListValue.getAlternateNameEncoding()));
                }
                if (attributesListValue != null && attributesListValue.getValue() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Value", StringUtils.fromString(attributesListValue.getValue()));
                }
                if (attributesListValue != null && attributesListValue.getAlternateValueEncoding() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".AlternateValueEncoding", StringUtils.fromString(attributesListValue.getAlternateValueEncoding()));
                }
                ++attributesListIndex;
            }
        }
        if (deleteAttributesRequest != null) {
            UpdateCondition expected = deleteAttributesRequest.getExpected();
            if (expected != null && expected.getName() != null) {
                request.addParameter("Expected.Name", StringUtils.fromString(expected.getName()));
            }
            if (expected != null && expected.getValue() != null) {
                request.addParameter("Expected.Value", StringUtils.fromString(expected.getValue()));
            }
            if (expected != null && expected.isExists() != null) {
                request.addParameter("Expected.Exists", StringUtils.fromBoolean(expected.isExists()));
            }
        }
        return request;
    }
}

