/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.pop3;

import com.sun.mail.pop3.AppendStream;
import com.sun.mail.pop3.POP3Folder;
import com.sun.mail.pop3.POP3Store;
import com.sun.mail.pop3.TempFile;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.Enumeration;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.IllegalWriteException;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.SharedInputStream;

public class POP3Message
extends MimeMessage {
    static final String UNKNOWN = "UNKNOWN";
    private POP3Folder folder;
    private int hdrSize = -1;
    private int msgSize = -1;
    String uid = "UNKNOWN";
    private SoftReference contentData = new SoftReference<Object>(null);
    static final /* synthetic */ boolean $assertionsDisabled;

    public POP3Message(Folder folder, int msgno) throws MessagingException {
        super(folder, msgno);
        this.folder = (POP3Folder)folder;
    }

    public synchronized void setFlags(Flags newFlags, boolean set) throws MessagingException {
        Flags oldFlags = (Flags)this.flags.clone();
        super.setFlags(newFlags, set);
        if (!this.flags.equals(oldFlags)) {
            this.folder.notifyMessageChangedListeners(1, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() throws MessagingException {
        try {
            POP3Message pOP3Message = this;
            synchronized (pOP3Message) {
                if (this.msgSize > 0) {
                    return this.msgSize;
                }
            }
            if (this.headers == null) {
                this.loadHeaders();
            }
            pOP3Message = this;
            synchronized (pOP3Message) {
                if (this.msgSize < 0) {
                    this.msgSize = this.folder.getProtocol().list(this.msgnum) - this.hdrSize;
                }
                return this.msgSize;
            }
        }
        catch (EOFException eex) {
            this.folder.close(false);
            throw new FolderClosedException(this.folder, eex.toString());
        }
        catch (IOException ex) {
            throw new MessagingException("error getting size", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getContentStream() throws MessagingException {
        InputStream cstream = null;
        try {
            POP3Message pOP3Message = this;
            synchronized (pOP3Message) {
                cstream = (InputStream)this.contentData.get();
                if (cstream == null) {
                    InputStream rawcontent = null;
                    TempFile cache = this.folder.getFileCache();
                    if (cache != null) {
                        Session s = ((POP3Store)this.folder.getStore()).getSession();
                        if (s.getDebug()) {
                            s.getDebugOut().println("DEBUG POP3: caching message #" + this.msgnum + " in temp file");
                        }
                        AppendStream os = cache.getAppendStream();
                        BufferedOutputStream bos = new BufferedOutputStream(os);
                        try {
                            this.folder.getProtocol().retr(this.msgnum, bos);
                            Object var9_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_14 = null;
                            bos.close();
                            throw throwable;
                        }
                        bos.close();
                        rawcontent = os.getInputStream();
                    } else {
                        rawcontent = this.folder.getProtocol().retr(this.msgnum, this.msgSize > 0 ? this.msgSize + this.hdrSize : 0);
                    }
                    if (rawcontent == null) {
                        this.expunged = true;
                        throw new MessageRemovedException("can't retrieve message #" + this.msgnum + " in POP3Message.getContentStream");
                    }
                    if (this.headers == null || ((POP3Store)this.folder.getStore()).forgetTopHeaders) {
                        this.headers = new InternetHeaders(rawcontent);
                        this.hdrSize = (int)((SharedInputStream)((Object)rawcontent)).getPosition();
                    } else {
                        int len;
                        boolean offset = false;
                        block8: do {
                            int c1;
                            len = 0;
                            while ((c1 = rawcontent.read()) >= 0 && c1 != 10) {
                                if (c1 == 13) {
                                    if (rawcontent.available() <= 0) continue block8;
                                    rawcontent.mark(1);
                                    if (rawcontent.read() == 10) continue block8;
                                    rawcontent.reset();
                                    continue block8;
                                }
                                ++len;
                            }
                        } while (rawcontent.available() != 0 && len != 0);
                        this.hdrSize = (int)((SharedInputStream)((Object)rawcontent)).getPosition();
                    }
                    cstream = ((SharedInputStream)((Object)rawcontent)).newStream(this.hdrSize, -1L);
                    this.msgSize = cstream.available();
                    rawcontent = null;
                    if (cache != null || ((POP3Store)this.folder.getStore()).keepMessageContent) {
                        this.contentStream = cstream;
                    }
                    this.contentData = new SoftReference<InputStream>(cstream);
                } else {
                    cstream = ((SharedInputStream)((Object)cstream)).newStream(0L, -1L);
                }
            }
        }
        catch (EOFException eex) {
            this.folder.close(false);
            throw new FolderClosedException(this.folder, eex.toString());
        }
        catch (IOException ex) {
            throw new MessagingException("error fetching POP3 content", ex);
        }
        return cstream;
    }

    public synchronized void invalidate(boolean invalidateHeaders) {
        this.content = null;
        InputStream cstream = (InputStream)this.contentData.get();
        if (cstream != null) {
            try {
                cstream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.contentData = new SoftReference<Object>(null);
            this.contentStream = null;
        }
        this.msgSize = -1;
        if (invalidateHeaders) {
            this.headers = null;
            this.hdrSize = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream top(int n) throws MessagingException {
        try {
            POP3Message pOP3Message = this;
            synchronized (pOP3Message) {
                return this.folder.getProtocol().top(this.msgnum, n);
            }
        }
        catch (EOFException eex) {
            this.folder.close(false);
            throw new FolderClosedException(this.folder, eex.toString());
        }
        catch (IOException ex) {
            throw new MessagingException("error getting size", ex);
        }
    }

    public String[] getHeader(String name) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(name, delimiter);
    }

    public void setHeader(String name, String value) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public void addHeader(String name, String value) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public void removeHeader(String name) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public Enumeration getAllHeaders() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaders(names);
    }

    public Enumeration getNonMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaders(names);
    }

    public void addHeaderLine(String line) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaderLines(names);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaderLines(names);
    }

    public void saveChanges() throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public synchronized void writeTo(OutputStream os, String[] ignoreList) throws IOException, MessagingException {
        if (this.content == null && ignoreList == null && !((POP3Store)this.folder.getStore()).cacheWriteTo) {
            Session s = ((POP3Store)this.folder.getStore()).getSession();
            if (s.getDebug()) {
                s.getDebugOut().println("DEBUG POP3: streaming msg " + this.msgnum);
            }
            if (!this.folder.getProtocol().retr(this.msgnum, os)) {
                this.expunged = true;
                throw new MessageRemovedException("can't retrieve message #" + this.msgnum + " in POP3Message.writeTo");
            }
        } else {
            super.writeTo(os, ignoreList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadHeaders() throws MessagingException {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        try {
            boolean fetchContent = false;
            POP3Message pOP3Message = this;
            synchronized (pOP3Message) {
                if (this.headers != null) {
                    return;
                }
                InputStream hdrs = null;
                if (((POP3Store)this.folder.getStore()).disableTop || (hdrs = this.folder.getProtocol().top(this.msgnum, 0)) == null) {
                    fetchContent = true;
                } else {
                    try {
                        this.hdrSize = hdrs.available();
                        this.headers = new InternetHeaders(hdrs);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        hdrs.close();
                        throw throwable;
                    }
                    hdrs.close();
                    {
                    }
                }
            }
            if (!fetchContent) return;
            InputStream cs = null;
            try {
                cs = this.getContentStream();
                Object var8_10 = null;
                if (cs == null) return;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (cs == null) throw throwable;
                cs.close();
                throw throwable;
            }
            cs.close();
            return;
        }
        catch (EOFException eex) {
            this.folder.close(false);
            throw new FolderClosedException(this.folder, eex.toString());
        }
        catch (IOException ex) {
            throw new MessagingException("error loading POP3 headers", ex);
        }
    }

    static {
        $assertionsDisabled = !POP3Message.class.desiredAssertionStatus();
    }
}

