
package org.mule.module.s3.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.s3.S3Connector;
import org.mule.transformer.TransformerTemplate;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.util.TemplateParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * CreateObjectMessageProcessor invokes the {@link org.mule.module.s3.S3Connector#createObject(java.lang.String, java.lang.String, java.lang.Object, java.lang.Long, java.lang.String, java.lang.String, org.mule.module.s3.AccessControlList, org.mule.module.s3.StorageClass, java.util.Map)} method in {@link S3Connector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
public class CreateObjectMessageProcessor
    implements FlowConstructAware, MuleContextAware, Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    private Object bucketName;
    private String _bucketNameType;
    private Object key;
    private String _keyType;
    private Object content;
    private Object _contentType;
    private Object contentLength;
    private Long _contentLengthType;
    private Object contentMd5;
    private String _contentMd5Type;
    private Object contentType;
    private String _contentTypeType;
    private Object acl;
    private org.mule.module.s3.AccessControlList _aclType;
    private Object storageClass;
    private org.mule.module.s3.StorageClass _storageClassType;
    private Object userMetadata;
    private Map<String, String> _userMetadataType;
    private Object accessKey;
    private String _accessKeyType;
    private Object secretKey;
    private String _secretKeyType;
    private static Logger logger = LoggerFactory.getLogger(CreateObjectMessageProcessor.class);
    /**
     * Module object
     * 
     */
    private Object moduleObject;
    /**
     * Mule Context
     * 
     */
    private MuleContext muleContext;
    /**
     * Mule Expression Manager
     * 
     */
    private ExpressionManager expressionManager;
    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;
    /**
     * Flow construct
     * 
     */
    private FlowConstruct flowConstruct;
    /**
     * Variable used to track how many retries we have attempted on this message processor
     * 
     */
    private AtomicInteger retryCount;
    /**
     * Maximum number of retries that can be attempted.
     * 
     */
    private int retryMax;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
        retryCount = new AtomicInteger();
        expressionManager = muleContext.getExpressionManager();
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
        if (moduleObject == null) {
            try {
                moduleObject = muleContext.getRegistry().lookupObject(S3ConnectorConnectionManager.class);
                if (moduleObject == null) {
                    throw new InitialisationException(MessageFactory.createStaticMessage("Cannot find object"), this);
                }
            } catch (RegistrationException e) {
                throw new InitialisationException(CoreMessages.initialisationFailure("org.mule.module.s3.config.S3ConnectorConnectionManager"), e, this);
            }
        }
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    /**
     * Sets the instance of the object under which the processor will execute
     * 
     * @param moduleObject Instace of the module
     */
    public void setModuleObject(Object moduleObject) {
        this.moduleObject = moduleObject;
    }

    /**
     * Sets retryMax
     * 
     * @param value Value to set
     */
    public void setRetryMax(int value) {
        this.retryMax = value;
    }

    /**
     * Sets content
     * 
     * @param value Value to set
     */
    public void setContent(Object value) {
        this.content = value;
    }

    /**
     * Sets storageClass
     * 
     * @param value Value to set
     */
    public void setStorageClass(Object value) {
        this.storageClass = value;
    }

    /**
     * Sets acl
     * 
     * @param value Value to set
     */
    public void setAcl(Object value) {
        this.acl = value;
    }

    /**
     * Sets userMetadata
     * 
     * @param value Value to set
     */
    public void setUserMetadata(Object value) {
        this.userMetadata = value;
    }

    /**
     * Sets contentType
     * 
     * @param value Value to set
     */
    public void setContentType(Object value) {
        this.contentType = value;
    }

    /**
     * Sets contentMd5
     * 
     * @param value Value to set
     */
    public void setContentMd5(Object value) {
        this.contentMd5 = value;
    }

    /**
     * Sets contentLength
     * 
     * @param value Value to set
     */
    public void setContentLength(Object value) {
        this.contentLength = value;
    }

    /**
     * Sets bucketName
     * 
     * @param value Value to set
     */
    public void setBucketName(Object value) {
        this.bucketName = value;
    }

    /**
     * Sets key
     * 
     * @param value Value to set
     */
    public void setKey(Object value) {
        this.key = value;
    }

    /**
     * Sets accessKey
     * 
     * @param value Value to set
     */
    public void setAccessKey(Object value) {
        this.accessKey = value;
    }

    /**
     * Sets secretKey
     * 
     * @param value Value to set
     */
    public void setSecretKey(Object value) {
        this.secretKey = value;
    }

    /**
     * Get all superclasses and interfaces recursively.
     * 
     * @param classes List of classes to which to add all found super classes and interfaces.
     * @param clazz   The class to start the search with.
     */
    private void computeClassHierarchy(Class clazz, List classes) {
        for (Class current = clazz; (current!= null); current = current.getSuperclass()) {
            if (classes.contains(current)) {
                return ;
            }
            classes.add(current);
            for (Class currentInterface: current.getInterfaces()) {
                computeClassHierarchy(currentInterface, classes);
            }
        }
    }

    /**
     * Checks whether the specified class parameter is an instance of {@link List }
     * 
     * @param clazz <code>Class</code> to check.
     * @return
     */
    private boolean isListClass(Class clazz) {
        List<Class> classes = new ArrayList<Class>();
        computeClassHierarchy(clazz, classes);
        return classes.contains(List.class);
    }

    /**
     * Checks whether the specified class parameter is an instance of {@link Map }
     * 
     * @param clazz <code>Class</code> to check.
     * @return
     */
    private boolean isMapClass(Class clazz) {
        List<Class> classes = new ArrayList<Class>();
        computeClassHierarchy(clazz, classes);
        return classes.contains(Map.class);
    }

    private boolean isList(Type type) {
        if ((type instanceof Class)&&isListClass(((Class) type))) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return isList(((ParameterizedType) type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType) type).getUpperBounds();
            return ((upperBounds.length!= 0)&&isList(upperBounds[ 0 ]));
        }
        return false;
    }

    private boolean isMap(Type type) {
        if ((type instanceof Class)&&isMapClass(((Class) type))) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return isMap(((ParameterizedType) type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType) type).getUpperBounds();
            return ((upperBounds.length!= 0)&&isMap(upperBounds[ 0 ]));
        }
        return false;
    }

    private boolean isAssignableFrom(Type expectedType, Class clazz) {
        if (expectedType instanceof Class) {
            return ((Class) expectedType).isAssignableFrom(clazz);
        }
        if (expectedType instanceof ParameterizedType) {
            return isAssignableFrom(((ParameterizedType) expectedType).getRawType(), clazz);
        }
        if (expectedType instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType) expectedType).getUpperBounds();
            if (upperBounds.length!= 0) {
                return isAssignableFrom(upperBounds[ 0 ], clazz);
            }
        }
        return false;
    }

    private Object evaluate(MuleMessage muleMessage, Object source) {
        if (source instanceof String) {
            String stringSource = ((String) source);
            if (stringSource.startsWith(patternInfo.getPrefix())&&stringSource.endsWith(patternInfo.getSuffix())) {
                return expressionManager.evaluate(stringSource, muleMessage);
            } else {
                return expressionManager.parse(stringSource, muleMessage);
            }
        }
        return source;
    }

    private Object evaluateAndTransform(MuleMessage muleMessage, Type expectedType, Object source)
        throws TransformerException
    {
        if (source == null) {
            return source;
        }
        Object target = null;
        if (isList(source.getClass())) {
            if (isList(expectedType)) {
                List newList = new ArrayList();
                Type valueType = ((ParameterizedType) expectedType).getActualTypeArguments()[ 0 ];
                ListIterator iterator = ((List) source).listIterator();
                while (iterator.hasNext()) {
                    Object subTarget = iterator.next();
                    newList.add(evaluateAndTransform(muleMessage, valueType, subTarget));
                }
                target = newList;
            } else {
                target = source;
            }
        } else {
            if (isMap(source.getClass())) {
                if (isMap(expectedType)) {
                    Type keyType = Object.class;
                    Type valueType = Object.class;
                    if (expectedType instanceof ParameterizedType) {
                        keyType = ((ParameterizedType) expectedType).getActualTypeArguments()[ 0 ];
                        valueType = ((ParameterizedType) expectedType).getActualTypeArguments()[ 1 ];
                    }
                    Map map = ((Map) source);
                    Map newMap = new HashMap();
                    for (Object entryObj: map.entrySet()) {
                        {
                            Map.Entry entry = ((Map.Entry) entryObj);
                            Object newKey = evaluateAndTransform(muleMessage, keyType, entry.getKey());
                            Object newValue = evaluateAndTransform(muleMessage, valueType, entry.getValue());
                            newMap.put(newKey, newValue);
                        }
                    }
                    target = newMap;
                } else {
                    target = source;
                }
            } else {
                target = evaluate(muleMessage, source);
            }
        }
        if ((target!= null)&&(!isAssignableFrom(expectedType, target.getClass()))) {
            DataType sourceDataType = DataTypeFactory.create(target.getClass());
            DataType targetDataType = DataTypeFactory.create(((Class) expectedType));
            Transformer t = muleContext.getRegistry().lookupTransformer(sourceDataType, targetDataType);
            return t.transform(target);
        } else {
            return target;
        }
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(MuleEvent event)
        throws MuleException
    {
        MuleMessage muleMessage = event.getMessage();
        S3ConnectorConnectionManager castedModuleObject = null;
        if (moduleObject instanceof String) {
            castedModuleObject = ((S3ConnectorConnectionManager) muleContext.getRegistry().lookupObject(((String) moduleObject)));
            if (castedModuleObject == null) {
                throw new MessagingException(CoreMessages.failedToCreate("createObject"), event, new RuntimeException("Cannot find the configuration specified by the config-ref attribute."));
            }
        } else {
            castedModuleObject = ((S3ConnectorConnectionManager) moduleObject);
        }
        String transformedAccessKey = null;
        String transformedSecretKey = null;
        S3ConnectorLifecycleAdapter connection = null;
        try {
            if (accessKey!= null) {
                transformedAccessKey = ((String) evaluateAndTransform(muleMessage, CreateObjectMessageProcessor.class.getDeclaredField("_accessKeyType").getGenericType(), accessKey));
            } else {
                if (castedModuleObject.getAccessKey() == null) {
                    throw new MessagingException(CoreMessages.failedToCreate("createObject"), event, new RuntimeException("You must provide a accessKey at the config or the message processor level."));
                }
                transformedAccessKey = ((String) evaluateAndTransform(muleMessage, CreateObjectMessageProcessor.class.getDeclaredField("_accessKeyType").getGenericType(), castedModuleObject.getAccessKey()));
            }
            if (secretKey!= null) {
                transformedSecretKey = ((String) evaluateAndTransform(muleMessage, CreateObjectMessageProcessor.class.getDeclaredField("_secretKeyType").getGenericType(), secretKey));
            } else {
                if (castedModuleObject.getSecretKey() == null) {
                    throw new MessagingException(CoreMessages.failedToCreate("createObject"), event, new RuntimeException("You must provide a secretKey at the config or the message processor level."));
                }
                transformedSecretKey = ((String) evaluateAndTransform(muleMessage, CreateObjectMessageProcessor.class.getDeclaredField("_secretKeyType").getGenericType(), castedModuleObject.getSecretKey()));
            }
            String transformedBucketName = ((String) evaluateAndTransform(muleMessage, CreateObjectMessageProcessor.class.getDeclaredField("_bucketNameType").getGenericType(), bucketName));
            String transformedKey = ((String) evaluateAndTransform(muleMessage, CreateObjectMessageProcessor.class.getDeclaredField("_keyType").getGenericType(), key));
            Object transformedContent = ((Object) evaluateAndTransform(muleMessage, CreateObjectMessageProcessor.class.getDeclaredField("_contentType").getGenericType(), "#[payload]"));
            Long transformedContentLength = ((Long) evaluateAndTransform(muleMessage, CreateObjectMessageProcessor.class.getDeclaredField("_contentLengthType").getGenericType(), contentLength));
            String transformedContentMd5 = ((String) evaluateAndTransform(muleMessage, CreateObjectMessageProcessor.class.getDeclaredField("_contentMd5Type").getGenericType(), contentMd5));
            String transformedContentType = ((String) evaluateAndTransform(muleMessage, CreateObjectMessageProcessor.class.getDeclaredField("_contentTypeType").getGenericType(), contentType));
            org.mule.module.s3.AccessControlList transformedAcl = ((org.mule.module.s3.AccessControlList) evaluateAndTransform(muleMessage, CreateObjectMessageProcessor.class.getDeclaredField("_aclType").getGenericType(), acl));
            org.mule.module.s3.StorageClass transformedStorageClass = ((org.mule.module.s3.StorageClass) evaluateAndTransform(muleMessage, CreateObjectMessageProcessor.class.getDeclaredField("_storageClassType").getGenericType(), storageClass));
            Map<String, String> transformedUserMetadata = ((Map<String, String> ) evaluateAndTransform(muleMessage, CreateObjectMessageProcessor.class.getDeclaredField("_userMetadataType").getGenericType(), userMetadata));
            if (logger.isDebugEnabled()) {
                StringBuffer messageStringBuffer = new StringBuffer();
                messageStringBuffer.append("Attempting to acquire a connection using ");
                messageStringBuffer.append("[accessKey = ");
                messageStringBuffer.append(transformedAccessKey);
                messageStringBuffer.append("] ");
                messageStringBuffer.append("[secretKey = ");
                messageStringBuffer.append(transformedSecretKey);
                messageStringBuffer.append("] ");
                logger.debug(messageStringBuffer.toString());
            }
            connection = castedModuleObject.acquireConnection(new S3ConnectorConnectionManager.ConnectionParameters(transformedAccessKey, transformedSecretKey));
            if (connection == null) {
                throw new MessagingException(CoreMessages.failedToCreate("createObject"), event, new RuntimeException("Cannot create connection"));
            } else {
                if (logger.isDebugEnabled()) {
                    StringBuffer messageStringBuffer = new StringBuffer();
                    messageStringBuffer.append("Connection has been acquired with ");
                    messageStringBuffer.append("[id = ");
                    messageStringBuffer.append(connection.connectionId());
                    messageStringBuffer.append("] ");
                    logger.debug(messageStringBuffer.toString());
                }
            }
            retryCount.getAndIncrement();
            Object resultPayload;
            resultPayload = connection.createObject(transformedBucketName, transformedKey, transformedContent, transformedContentLength, transformedContentMd5, transformedContentType, transformedAcl, transformedStorageClass, transformedUserMetadata);
            if (resultPayload == null) {
                event = new DefaultMuleEvent(new DefaultMuleMessage(NullPayload.getInstance(), muleContext), event);
            } else {
                List<Transformer> transformerList;
                transformerList = new ArrayList<Transformer>();
                transformerList.add(new TransformerTemplate(new TransformerTemplate.OverwitePayloadCallback(resultPayload)));
                event.getMessage().applyTransformers(event, transformerList);
            }
            retryCount.set(0);
            return event;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("createObject"), event, e);
        } finally {
            try {
                if (connection!= null) {
                    if (logger.isDebugEnabled()) {
                        StringBuffer messageStringBuffer = new StringBuffer();
                        messageStringBuffer.append("Releasing the connection back into the pool [id=");
                        messageStringBuffer.append(connection.connectionId());
                        messageStringBuffer.append("].");
                        logger.debug(messageStringBuffer.toString());
                    }
                    castedModuleObject.releaseConnection(new S3ConnectorConnectionManager.ConnectionParameters(transformedAccessKey, transformedSecretKey), connection);
                }
            } catch (Exception e) {
                throw new MessagingException(CoreMessages.failedToInvoke("createObject"), event, e);
            }
        }
    }

}
