/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.reboot;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.module.reboot.MuleContainerBootstrapUtils;

public class MuleContainerBootstrapUtilsTestCase {
    @Before
    public void setUp() {
        System.setProperty("mule.home", "foo");
    }

    @Test
    public void testIsStandaloneTrue() {
        Assert.assertTrue((boolean)MuleContainerBootstrapUtils.isStandalone());
    }

    @Test
    public void testGetMuleHomeFile() {
        File muleHome = MuleContainerBootstrapUtils.getMuleHome();
        Assert.assertNotNull((Object)muleHome.getAbsolutePath());
    }

    @Test
    public void testGetMuleAppsFile() {
        File muleApps = MuleContainerBootstrapUtils.getMuleAppsDir();
        Assert.assertNotNull((Object)muleApps.getAbsolutePath());
    }

    @Test
    public void testGetMuleLibDir() {
        File muleLib = MuleContainerBootstrapUtils.getMuleLibDir();
        Assert.assertNotNull((Object)muleLib.getAbsolutePath());
    }

    @Test
    public void testGetMuleLocalJarFile() {
        File muleLocalJar = MuleContainerBootstrapUtils.getMuleLocalJarFile();
        Assert.assertNotNull((Object)muleLocalJar.getAbsolutePath());
    }

    @Test
    public void testGetResource() throws IOException {
        URL resource = MuleContainerBootstrapUtils.getResource((String)"test-resource.txt", this.getClass());
        Assert.assertNotNull((Object)resource);
        Object content = resource.getContent();
        Assert.assertTrue((boolean)(content instanceof InputStream));
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)content));
        Assert.assertEquals((Object)"msg=Hello World", (Object)in.readLine());
    }

    @Test
    public void testRenameFile() throws IOException {
        File source = File.createTempFile("foo", ".tmp");
        File dest = new File(source.getParent() + File.separatorChar + "dest" + System.currentTimeMillis() + ".tmp");
        Assert.assertFalse((boolean)dest.exists());
        MuleContainerBootstrapUtils.renameFile((File)source, (File)dest);
        Assert.assertTrue((boolean)dest.exists());
        Assert.assertFalse((boolean)source.exists());
        source.delete();
        dest.delete();
    }

    @Test
    public void testRenameFileHard() throws IOException {
        File source = File.createTempFile("foo2", ".tmp");
        File dest = new File(source.getParent() + File.separatorChar + "dest2" + System.currentTimeMillis() + ".tmp");
        Assert.assertFalse((boolean)dest.exists());
        MuleContainerBootstrapUtils.renameFileHard((File)source, (File)dest);
        Assert.assertTrue((boolean)dest.exists());
        Assert.assertFalse((boolean)source.exists());
        source.delete();
        dest.delete();
    }

    @Test
    public void testCopy() throws IOException {
        byte[] b = new byte[]{0, 1, 2};
        ByteArrayInputStream input = new ByteArrayInputStream(b, 0, Integer.MAX_VALUE);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int i = MuleContainerBootstrapUtils.copy((InputStream)input, (OutputStream)output);
        Assert.assertEquals((long)b.length, (long)i);
    }

    @Test
    public void testCopyLarge() throws IOException {
        byte[] b = new byte[]{0, 1, 2};
        ByteArrayInputStream input = new ByteArrayInputStream(b, 0, Integer.MAX_VALUE);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        long i = MuleContainerBootstrapUtils.copyLarge((InputStream)input, (OutputStream)output);
        Assert.assertEquals((long)b.length, (long)i);
    }
}

