/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.quickbooks.windows.api;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import net.sf.staccatocommons.collections.stream.Streams;
import org.apache.commons.lang.Validate;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.mule.modules.quickbooks.api.AbstractQuickBooksClient;
import org.mule.modules.quickbooks.api.exception.ErrorInfo;
import org.mule.modules.quickbooks.api.exception.ExceptionInfo;
import org.mule.modules.quickbooks.api.exception.QuickBooksRuntimeException;
import org.mule.modules.quickbooks.utils.MessageUtils;
import org.mule.modules.quickbooks.windows.WindowsEntityType;
import org.mule.modules.quickbooks.windows.api.QuickBooksWindowsClient;
import org.mule.modules.quickbooks.windows.objectfactory.QBWMessageUtils;
import org.mule.modules.quickbooks.windows.schema.AddRequest;
import org.mule.modules.quickbooks.windows.schema.CdmBase;
import org.mule.modules.quickbooks.windows.schema.CdmObject;
import org.mule.modules.quickbooks.windows.schema.DelRequest;
import org.mule.modules.quickbooks.windows.schema.ErrorResponse;
import org.mule.modules.quickbooks.windows.schema.IdType;
import org.mule.modules.quickbooks.windows.schema.ModRequest;
import org.mule.modules.quickbooks.windows.schema.QueryBase;
import org.mule.modules.quickbooks.windows.schema.RevertRequest;
import org.mule.modules.quickbooks.windows.schema.SuccessResponse;
import org.mule.modules.quickbooks.windows.schema.UserInformation;
import org.mule.modules.quickbooks.windows.schema.UserResponse;
import org.mule.modules.utils.MuleSoftException;
import org.mule.modules.utils.pagination.PaginatedIterable;

public class DefaultQuickBooksWindowsClient
extends AbstractQuickBooksClient
implements QuickBooksWindowsClient {
    public DefaultQuickBooksWindowsClient(String baseUri, String serviceProviderId) {
        Validate.notEmpty((String)baseUri);
        this.init(baseUri, serviceProviderId);
    }

    @Override
    public Object create(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym, WindowsEntityType type, Object obj, String requestId, Boolean draft, Boolean fullResponse) {
        Validate.notNull((Object)obj);
        this.loadCompanyData(realmId, appKey, realmIdPseudonym, authIdPseudonym);
        String str = String.format("%s/%s/v2/%s", this.getBaseUri(realmId), type.getResouceName(), realmId);
        HttpPost httpRequest = new HttpPost(str);
        httpRequest.addHeader("Content-Type", "text/xml");
        AddRequest addRequest = new AddRequest();
        addRequest.setRequestId(requestId);
        addRequest.setCdmObject((JAXBElement<? extends CdmObject>)this.getMessageUtilsInstance().createJaxbElement(obj));
        addRequest.setDraft(draft);
        addRequest.setFullResponse(fullResponse);
        this.prepareToPost(addRequest, (HttpUriRequest)httpRequest);
        try {
            Object respObj = this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, appKey, this.getAccessToken(realmId));
            if (respObj instanceof ErrorResponse) {
                throw new QuickBooksRuntimeException(new ErrorInfo(respObj));
            }
            if (fullResponse != null && fullResponse.booleanValue()) {
                return ((SuccessResponse)respObj).getCdmObject().getValue();
            }
            return ((SuccessResponse)respObj).getCdmObjectRef().getValue();
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                this.destroyAccessToken(realmId);
                return this.create(realmId, appKey, realmIdPseudonym, authIdPseudonym, type, obj, requestId, draft, fullResponse);
            }
            throw e;
        }
    }

    @Override
    public Object getObject(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym, WindowsEntityType type, IdType id) {
        Validate.notNull((Object)((Object)type));
        Validate.notNull((Object)id);
        this.loadCompanyData(realmId, appKey, realmIdPseudonym, authIdPseudonym);
        String str = String.format("%s/%s/v2/%s/%s?idDomain=%s", this.getBaseUri(realmId), type.getResouceName(), realmId, id.getValue(), id.getIdDomain().value());
        HttpGet httpRequest = new HttpGet(str);
        try {
            Object respObj = this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, appKey, this.getAccessToken(realmId));
            if (respObj instanceof ErrorResponse) {
                throw new QuickBooksRuntimeException(new ErrorInfo(respObj));
            }
            return Streams.from((List)this.getListFromIntuitResponse(respObj, type)).anyOrNull();
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                this.destroyAccessToken(realmId);
                return this.getObject(realmId, appKey, realmIdPseudonym, authIdPseudonym, type, id);
            }
            throw e;
        }
    }

    private List getListFromIntuitResponse(Object response, WindowsEntityType type) {
        try {
            if (type.getType().getSimpleName().equals("Class")) {
                return (List)response.getClass().getMethod("getClazz", new Class[0]).invoke(response, new Object[0]);
            }
            return (List)response.getClass().getMethod("get" + type.getType().getSimpleName(), new Class[0]).invoke(response, new Object[0]);
        }
        catch (Exception e) {
            throw MuleSoftException.soften((Throwable)e);
        }
    }

    @Override
    public Object update(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym, WindowsEntityType type, Object obj, String requestId, Boolean draft, Boolean fullResponse) {
        Validate.notNull((Object)obj);
        this.loadCompanyData(realmId, appKey, realmIdPseudonym, authIdPseudonym);
        if (((CdmBase)obj).getSyncToken() == null) {
            ((CdmBase)obj).setSyncToken(((CdmBase)this.getObject(realmId, appKey, realmIdPseudonym, authIdPseudonym, type, ((CdmBase)obj).getId())).getSyncToken());
        }
        String str = String.format("%s/%s/v2/%s", this.getBaseUri(realmId), type.getResouceName(), realmId);
        HttpPost httpRequest = new HttpPost(str);
        httpRequest.addHeader("Content-Type", "text/xml");
        ModRequest modRequest = new ModRequest();
        modRequest.setRequestId(requestId);
        modRequest.setCdmObject((JAXBElement<? extends CdmObject>)this.getMessageUtilsInstance().createJaxbElement(obj));
        modRequest.setDraft(draft);
        modRequest.setFullResponse(fullResponse);
        this.prepareToPost(modRequest, (HttpUriRequest)httpRequest);
        try {
            Object respObj = this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, appKey, this.getAccessToken(realmId));
            if (respObj instanceof ErrorResponse) {
                throw new QuickBooksRuntimeException(new ErrorInfo(respObj));
            }
            if (fullResponse != null && fullResponse.booleanValue()) {
                return ((SuccessResponse)respObj).getCdmObject().getValue();
            }
            return ((SuccessResponse)respObj).getCdmObjectRef().getValue();
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                this.destroyAccessToken(realmId);
                return this.update(realmId, appKey, realmIdPseudonym, authIdPseudonym, type, obj, requestId, draft, fullResponse);
            }
            throw e;
        }
    }

    @Override
    public void delete(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym, WindowsEntityType type, Object obj, String requestId) {
        Validate.notNull((Object)((Object)type));
        Validate.notNull((Object)obj);
        Validate.notNull((Object)((CdmBase)obj).getId());
        Validate.isTrue((((CdmBase)obj).getId().getValue() != null && !((CdmBase)obj).getId().getValue().equals("") ? 1 : 0) != 0);
        this.loadCompanyData(realmId, appKey, realmIdPseudonym, authIdPseudonym);
        if (((CdmBase)obj).getSyncToken() == null || ((CdmBase)obj).getMetaData() == null) {
            obj = this.getObject(realmId, appKey, realmIdPseudonym, authIdPseudonym, type, ((CdmBase)obj).getId());
        }
        String str = String.format("%s/%s/v2/%s", this.getBaseUri(realmId), type.getResouceName(), realmId);
        HttpPost httpRequest = new HttpPost(str);
        httpRequest.addHeader("Content-Type", "text/xml");
        DelRequest delRequest = new DelRequest();
        delRequest.setRequestId(requestId);
        delRequest.setCdmObject((JAXBElement<? extends CdmObject>)this.getMessageUtilsInstance().createJaxbElement(obj));
        this.prepareToPost(delRequest, (HttpUriRequest)httpRequest);
        try {
            Object respObj = this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, appKey, this.getAccessToken(realmId));
            if (respObj instanceof ErrorResponse) {
                throw new QuickBooksRuntimeException(new ErrorInfo(respObj));
            }
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                this.destroyAccessToken(realmId);
                this.delete(realmId, appKey, realmIdPseudonym, authIdPseudonym, type, obj, requestId);
            }
            throw e;
        }
    }

    @Override
    public Iterable findObjectsGetPages(final String realmId, final String appKey, final String realmIdPseudonym, final String authIdPseudonym, final WindowsEntityType type, final Object query) {
        Validate.notNull((Object)((Object)type));
        return new PaginatedIterable<Object, List<Object>>(){
            private Integer countPage = 1;

            protected List<Object> firstPage() {
                return this.askAnEspecificPage(this.countPage);
            }

            protected boolean hasNextPage(List<Object> arg0) {
                return arg0.isEmpty();
            }

            protected List<Object> nextPage(List<Object> arg0) {
                this.countPage = this.countPage + 1;
                return this.askAnEspecificPage(this.countPage);
            }

            protected Iterator<Object> pageIterator(List<Object> arg0) {
                return arg0.iterator();
            }

            private List<Object> askAnEspecificPage(Integer pageNumber) {
                DefaultQuickBooksWindowsClient.this.loadCompanyData(realmId, appKey, realmIdPseudonym, authIdPseudonym);
                String str = String.format("%s/%s/v2/%s", DefaultQuickBooksWindowsClient.this.getBaseUri(realmId), type.getResouceName(), realmId);
                HttpPost httpRequest = new HttpPost(str);
                httpRequest.addHeader("Content-Type", "text/xml");
                ((QueryBase)query).setStartPage(BigInteger.valueOf(pageNumber.intValue()));
                ((QueryBase)query).setChunkSize(DefaultQuickBooksWindowsClient.this.getResultsPerPage());
                DefaultQuickBooksWindowsClient.this.prepareToPost(query, (HttpUriRequest)httpRequest);
                try {
                    Object respObj = DefaultQuickBooksWindowsClient.this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, appKey, DefaultQuickBooksWindowsClient.this.getAccessToken(realmId));
                    if (respObj instanceof ErrorResponse) {
                        throw new QuickBooksRuntimeException(new ErrorInfo(respObj));
                    }
                    return DefaultQuickBooksWindowsClient.this.getListFromIntuitResponse(respObj, type);
                }
                catch (QuickBooksRuntimeException e) {
                    if (e.isAExpiredTokenFault()) {
                        DefaultQuickBooksWindowsClient.this.destroyAccessToken(realmId);
                        return this.askAnEspecificPage(pageNumber);
                    }
                    throw e;
                }
            }
        };
    }

    @Override
    public Iterable findObjects(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym, WindowsEntityType type, Object query) {
        Validate.notNull((Object)((Object)type));
        ArrayList listOfResults = new ArrayList();
        Boolean hasMoreResults = true;
        Integer pageNumber = 0;
        this.loadCompanyData(realmId, appKey, realmIdPseudonym, authIdPseudonym);
        String str = String.format("%s/%s/v2/%s", this.getBaseUri(realmId), type.getResouceName(), realmId);
        while (hasMoreResults.booleanValue()) {
            Object responseObject;
            Integer n = pageNumber;
            Integer n2 = pageNumber = Integer.valueOf(pageNumber + 1);
            HttpPost httpRequest = new HttpPost(str);
            httpRequest.addHeader("Content-Type", "text/xml");
            ((QueryBase)query).setStartPage(BigInteger.valueOf(pageNumber.intValue()));
            ((QueryBase)query).setChunkSize(this.getResultsPerPage());
            this.prepareToPost(query, (HttpUriRequest)httpRequest);
            try {
                responseObject = this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, appKey, this.getAccessToken(realmId));
                if (responseObject instanceof ErrorResponse) {
                    throw new QuickBooksRuntimeException(new ErrorInfo(responseObject));
                }
            }
            catch (QuickBooksRuntimeException e) {
                if (e.isAExpiredTokenFault()) {
                    this.destroyAccessToken(realmId);
                    responseObject = this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, appKey, this.getAccessToken(realmId));
                }
                throw e;
            }
            List intuitList = this.getListFromIntuitResponse(responseObject, type);
            if (intuitList != null) {
                hasMoreResults = intuitList.size() >= this.getResultsPerPage();
                listOfResults.addAll(intuitList);
                continue;
            }
            hasMoreResults = false;
        }
        return listOfResults;
    }

    @Override
    public Object retrieveWithoutUsingQueryObjects(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym, Object syncStatusRequest, String objectName) {
        Validate.notNull((Object)syncStatusRequest);
        this.loadCompanyData(realmId, appKey, realmIdPseudonym, authIdPseudonym);
        String str = String.format("%s/%s/v2/%s", this.getBaseUri(realmId), objectName, realmId);
        HttpPost httpRequest = new HttpPost(str);
        httpRequest.addHeader("Content-Type", "text/xml");
        this.prepareToPost(syncStatusRequest, (HttpUriRequest)httpRequest);
        try {
            Object respObj = this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, appKey, this.getAccessToken(realmId));
            if (respObj instanceof ErrorResponse) {
                throw new QuickBooksRuntimeException(new ErrorInfo(respObj));
            }
            return respObj;
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                this.destroyAccessToken(realmId);
                return this.retrieveWithoutUsingQueryObjects(realmId, appKey, realmIdPseudonym, authIdPseudonym, syncStatusRequest, objectName);
            }
            throw e;
        }
    }

    @Override
    public void revert(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym, WindowsEntityType type, Object obj, String requestId) {
        Validate.notNull((Object)((Object)type));
        this.loadCompanyData(realmId, appKey, realmIdPseudonym, authIdPseudonym);
        String str = String.format("%s/%s/v2/%s", this.getBaseUri(realmId), type.getResouceName(), realmId);
        HttpPost httpRequest = new HttpPost(str);
        httpRequest.addHeader("Content-Type", "text/xml");
        RevertRequest revertRequest = new RevertRequest();
        revertRequest.setRequestId(requestId);
        revertRequest.setCdmObject((JAXBElement<? extends CdmObject>)this.getMessageUtilsInstance().createJaxbElement(obj));
        this.prepareToPost(revertRequest, (HttpUriRequest)httpRequest);
        try {
            Object respObj = this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, appKey, this.getAccessToken(realmId));
            if (respObj instanceof ErrorResponse) {
                throw new QuickBooksRuntimeException(new ErrorInfo(respObj));
            }
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                this.destroyAccessToken(realmId);
                this.revert(realmId, appKey, realmIdPseudonym, authIdPseudonym, type, obj, requestId);
            }
            throw e;
        }
    }

    @Override
    public String generateARequestId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    protected ExceptionInfo getFaultInfo(String str) throws JAXBException {
        if (str.contains("oauth_problem=token_rejected")) {
            ExceptionInfo exceptionInfo = new ExceptionInfo();
            exceptionInfo.setCause("SERVER");
            exceptionInfo.setErrorCode("401");
            exceptionInfo.setMessage("Unauthorized OAuth Token: token_rejected");
            return exceptionInfo;
        }
        return null;
    }

    protected MessageUtils getMessageUtilsInstance() {
        return QBWMessageUtils.getInstance();
    }

    protected String loadCompanyBaseUri(String realmId, String appKey, String accessToken) {
        return this.baseUri;
    }

    @Override
    public UserInformation getCurrentUserInformation(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym) {
        return ((UserResponse)this.retrieveUserInformation(realmId, appKey, realmIdPseudonym, authIdPseudonym)).getUser();
    }

    @Override
    public Object get(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym, WindowsEntityType type) {
        Validate.notNull((Object)((Object)type));
        this.loadCompanyData(realmId, appKey, realmIdPseudonym, authIdPseudonym);
        String str = String.format("%s/%s/v2/%s", this.getBaseUri(realmId), type.getResouceName(), realmId);
        HttpGet httpRequest = new HttpGet(str);
        try {
            Object respObj = this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, appKey, this.getAccessToken(realmId));
            if (respObj instanceof ErrorResponse) {
                throw new QuickBooksRuntimeException(new ErrorInfo(respObj));
            }
            return Streams.from((List)this.getListFromIntuitResponse(respObj, type)).anyOrNull();
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                this.destroyAccessToken(realmId);
                return this.get(realmId, appKey, realmIdPseudonym, authIdPseudonym, type);
            }
            throw e;
        }
    }
}

