/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.quickbooks.windows;

import com.zauberlabs.commons.mom.MapObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.display.Placement;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.modules.quickbooks.windows.WindowsEntityType;
import org.mule.modules.quickbooks.windows.api.DefaultQuickBooksWindowsClient;
import org.mule.modules.quickbooks.windows.api.QuickBooksWindowsClient;
import org.mule.modules.quickbooks.windows.schema.IdType;
import org.mule.modules.quickbooks.windows.schema.SyncActivityRequest;
import org.mule.modules.quickbooks.windows.schema.SyncActivityResponse;
import org.mule.modules.quickbooks.windows.schema.SyncActivityResponses;
import org.mule.modules.quickbooks.windows.schema.SyncStatusRequest;
import org.mule.modules.quickbooks.windows.schema.SyncStatusResponse;
import org.mule.modules.quickbooks.windows.schema.SyncStatusResponses;
import org.mule.modules.quickbooks.windows.schema.UserInformation;
import org.mule.modules.utils.mom.JaxbMapObjectMappers;

@Module(name="quickbooks-windows", schemaVersion="3.0", friendlyName="Quickbooks Windows")
public class QuickBooksWindowsModule {
    @Configurable
    @Optional
    private QuickBooksWindowsClient client;
    private final MapObjectMapper mom = JaxbMapObjectMappers.defaultWithPackage((String)"org.mule.modules.quickbooks.windows.schema").build();
    @Optional
    @Default(value="https://services.intuit.com/sb")
    @Configurable
    private String baseUri;
    @Configurable
    private String serviceProviderId;

    @Processor
    public Object create(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym, WindowsEntityType type, @Optional @Default(value="#[payload]") Object entityObject, @Optional @Default(value="false") Boolean draft, @Optional @Default(value="false") Boolean fullResponse) {
        return this.client.create(realmId, appKey, realmIdPseudonym, authIdPseudonym, type, entityObject, this.generateANewRequestId(), draft, fullResponse);
    }

    @Processor
    public Object getObject(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym, WindowsEntityType type, @Optional @Default(value="#[payload]") Object idType) {
        return this.client.getObject(realmId, appKey, realmIdPseudonym, authIdPseudonym, type, (IdType)idType);
    }

    @Processor
    public Object update(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym, WindowsEntityType type, @Optional @Default(value="#[payload]") Object entityObject, @Optional @Default(value="false") Boolean draft, @Optional @Default(value="false") Boolean fullResponse) {
        return this.client.update(realmId, appKey, realmIdPseudonym, authIdPseudonym, type, entityObject, this.generateANewRequestId(), draft, fullResponse);
    }

    @Processor
    public void delete(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym, WindowsEntityType type, @Optional @Default(value="#[payload]") Object entityObject) {
        this.client.delete(realmId, appKey, realmIdPseudonym, authIdPseudonym, type, entityObject, this.generateANewRequestId());
    }

    @Processor
    public Iterable findObjects(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym, WindowsEntityType type, @Optional @Placement(group="Query") Map<String, Object> query) {
        if (query == null) {
            query = new HashMap<String, Object>();
        }
        return this.client.findObjects(realmId, appKey, realmIdPseudonym, authIdPseudonym, type, this.unmap(type.getQueryType(), query));
    }

    @Processor
    public String generateANewRequestId() {
        return this.client.generateARequestId();
    }

    @Processor
    public List<SyncStatusResponse> status(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym, @Optional @Placement(group="Sync Status Request") Map<String, Object> syncStatusRequest) {
        if (syncStatusRequest == null) {
            syncStatusRequest = new HashMap<String, Object>();
        }
        return ((SyncStatusResponses)this.client.retrieveWithoutUsingQueryObjects(realmId, appKey, realmIdPseudonym, authIdPseudonym, this.unmap(SyncStatusRequest.class, syncStatusRequest), "status")).getSyncStatusResponse();
    }

    @Processor
    public List<SyncActivityResponse> syncActivity(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym, @Optional @Placement(group="Sync Activity Request") Map<String, Object> syncActivityRequest) {
        if (syncActivityRequest == null) {
            syncActivityRequest = new HashMap<String, Object>();
        }
        return ((SyncActivityResponses)this.client.retrieveWithoutUsingQueryObjects(realmId, appKey, realmIdPseudonym, authIdPseudonym, this.unmap(SyncActivityRequest.class, syncActivityRequest), "syncActivity")).getSyncActivityResponse();
    }

    @Processor
    public UserInformation getCurrentUser(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym) {
        return this.client.getCurrentUserInformation(realmId, appKey, realmIdPseudonym, authIdPseudonym);
    }

    @Processor
    public Object getCompanyMetadata(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym) {
        return this.client.get(realmId, appKey, realmIdPseudonym, authIdPseudonym, WindowsEntityType.COMPANY_METADATA);
    }

    @PostConstruct
    public void init() {
        if (this.client == null) {
            this.client = new DefaultQuickBooksWindowsClient(this.baseUri, this.serviceProviderId);
        }
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    private <A> A unmap(Class<A> class1, Map<String, Object> id) {
        return (A)this.mom.unmap(id, class1);
    }

    public QuickBooksWindowsClient getClient() {
        return this.client;
    }

    public void setClient(QuickBooksWindowsClient client) {
        this.client = client;
    }

    public String getServiceProviderId() {
        return this.serviceProviderId;
    }

    public void setServiceProviderId(String serviceProviderId) {
        this.serviceProviderId = serviceProviderId;
    }
}

