
package org.mule.modules.quickbooks.windows.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.quickbooks.windows.QuickBooksWindowsModule;
import org.mule.modules.quickbooks.windows.WindowsEntityType;
import org.mule.modules.quickbooks.windows.adapters.QuickBooksWindowsModuleProcessAdapter;


/**
 * DeleteMessageProcessor invokes the {@link org.mule.modules.quickbooks.windows.QuickBooksWindowsModule#delete(java.lang.String, java.lang.String, java.lang.String, java.lang.String, org.mule.modules.quickbooks.windows.WindowsEntityType, java.lang.Object)} method in {@link QuickBooksWindowsModule }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.1", date = "2013-01-28T04:35:01-03:00", comments = "Build 3.3.1.1298.3ae82a7")
public class DeleteMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object realmId;
    protected String _realmIdType;
    protected Object appKey;
    protected String _appKeyType;
    protected Object realmIdPseudonym;
    protected String _realmIdPseudonymType;
    protected Object authIdPseudonym;
    protected String _authIdPseudonymType;
    protected Object type;
    protected WindowsEntityType _typeType;
    protected Object entityObject;
    protected Object _entityObjectType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets entityObject
     * 
     * @param value Value to set
     */
    public void setEntityObject(Object value) {
        this.entityObject = value;
    }

    /**
     * Sets realmIdPseudonym
     * 
     * @param value Value to set
     */
    public void setRealmIdPseudonym(Object value) {
        this.realmIdPseudonym = value;
    }

    /**
     * Sets type
     * 
     * @param value Value to set
     */
    public void setType(Object value) {
        this.type = value;
    }

    /**
     * Sets authIdPseudonym
     * 
     * @param value Value to set
     */
    public void setAuthIdPseudonym(Object value) {
        this.authIdPseudonym = value;
    }

    /**
     * Sets appKey
     * 
     * @param value Value to set
     */
    public void setAppKey(Object value) {
        this.appKey = value;
    }

    /**
     * Sets realmId
     * 
     * @param value Value to set
     */
    public void setRealmId(Object value) {
        this.realmId = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        try {
            findOrCreate(QuickBooksWindowsModuleProcessAdapter.class, false, event);
            final String _transformedRealmId = ((String) evaluateAndTransform(getMuleContext(), event, DeleteMessageProcessor.class.getDeclaredField("_realmIdType").getGenericType(), null, realmId));
            final String _transformedAppKey = ((String) evaluateAndTransform(getMuleContext(), event, DeleteMessageProcessor.class.getDeclaredField("_appKeyType").getGenericType(), null, appKey));
            final String _transformedRealmIdPseudonym = ((String) evaluateAndTransform(getMuleContext(), event, DeleteMessageProcessor.class.getDeclaredField("_realmIdPseudonymType").getGenericType(), null, realmIdPseudonym));
            final String _transformedAuthIdPseudonym = ((String) evaluateAndTransform(getMuleContext(), event, DeleteMessageProcessor.class.getDeclaredField("_authIdPseudonymType").getGenericType(), null, authIdPseudonym));
            final WindowsEntityType _transformedType = ((WindowsEntityType) evaluateAndTransform(getMuleContext(), event, DeleteMessageProcessor.class.getDeclaredField("_typeType").getGenericType(), null, type));
            final Object _transformedEntityObject = ((Object) evaluateAndTransform(getMuleContext(), event, DeleteMessageProcessor.class.getDeclaredField("_entityObjectType").getGenericType(), null, entityObject));
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) getModuleObject()).getProcessTemplate();
            processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    ((QuickBooksWindowsModule) object).delete(_transformedRealmId, _transformedAppKey, _transformedRealmIdPseudonym, _transformedAuthIdPseudonym, _transformedType, _transformedEntityObject);
                    return null;
                }

            }
            , this, event);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("delete"), event, e);
        }
    }

}
