
package org.mule.modules.quickbooks.windows.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.modules.quickbooks.windows.processors.SyncActivityMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SyncActivityDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public SyncActivityDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(SyncActivityMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("realmId")!= null)&&(!StringUtils.isBlank(element.getAttribute("realmId")))) {
            builder.addPropertyValue("realmId", element.getAttribute("realmId"));
        }
        if ((element.getAttribute("appKey")!= null)&&(!StringUtils.isBlank(element.getAttribute("appKey")))) {
            builder.addPropertyValue("appKey", element.getAttribute("appKey"));
        }
        if ((element.getAttribute("realmIdPseudonym")!= null)&&(!StringUtils.isBlank(element.getAttribute("realmIdPseudonym")))) {
            builder.addPropertyValue("realmIdPseudonym", element.getAttribute("realmIdPseudonym"));
        }
        if ((element.getAttribute("authIdPseudonym")!= null)&&(!StringUtils.isBlank(element.getAttribute("authIdPseudonym")))) {
            builder.addPropertyValue("authIdPseudonym", element.getAttribute("authIdPseudonym"));
        }
        Element syncActivityRequestListElement = null;
        syncActivityRequestListElement = DomUtils.getChildElementByTagName(element, "sync-activity-request");
        List<Element> syncActivityRequestMapChilds = null;
        if (syncActivityRequestListElement!= null) {
            String syncActivityRequestRef = syncActivityRequestListElement.getAttribute("ref");
            if ((syncActivityRequestRef!= null)&&(!StringUtils.isBlank(syncActivityRequestRef))) {
                if ((!syncActivityRequestRef.startsWith(patternInfo.getPrefix()))&&(!syncActivityRequestRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("syncActivityRequest", new RuntimeBeanReference(syncActivityRequestRef));
                } else {
                    builder.addPropertyValue("syncActivityRequest", syncActivityRequestRef);
                }
            } else {
                ManagedMap syncActivityRequest = new ManagedMap();
                syncActivityRequestMapChilds = DomUtils.getChildElementsByTagName(syncActivityRequestListElement, "sync-activity-request");
                if (syncActivityRequestMapChilds!= null) {
                    if (syncActivityRequestMapChilds.size() == 0) {
                        syncActivityRequestMapChilds = DomUtils.getChildElements(syncActivityRequestListElement);
                    }
                    for (Element syncActivityRequestChild: syncActivityRequestMapChilds) {
                        String syncActivityRequestValueRef = syncActivityRequestChild.getAttribute("value-ref");
                        String syncActivityRequestKeyRef = syncActivityRequestChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((syncActivityRequestValueRef!= null)&&(!StringUtils.isBlank(syncActivityRequestValueRef))) {
                            if ((!syncActivityRequestValueRef.startsWith(patternInfo.getPrefix()))&&(!syncActivityRequestValueRef.endsWith(patternInfo.getSuffix()))) {
                                valueObject = new RuntimeBeanReference(syncActivityRequestValueRef);
                            } else {
                                valueObject = syncActivityRequestValueRef;
                            }
                        } else {
                            valueObject = syncActivityRequestChild.getTextContent();
                        }
                        if ((syncActivityRequestKeyRef!= null)&&(!StringUtils.isBlank(syncActivityRequestKeyRef))) {
                            keyObject = new RuntimeBeanReference(syncActivityRequestKeyRef);
                        } else {
                            keyObject = syncActivityRequestChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = syncActivityRequestChild.getTagName();
                        }
                        syncActivityRequest.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("syncActivityRequest", syncActivityRequest);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
