
package org.mule.modules.quickbooks.windows.config;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/quickbooks-windows</code>.
 * 
 */
public class QuickBooksWindowsModuleNamespaceHandler
    extends NamespaceHandlerSupport
{


    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        registerBeanDefinitionParser("config", new QuickBooksWindowsModuleConfigDefinitionParser());
        registerBeanDefinitionParser("create", new CreateDefinitionParser());
        registerBeanDefinitionParser("get-object", new GetObjectDefinitionParser());
        registerBeanDefinitionParser("update", new UpdateDefinitionParser());
        registerBeanDefinitionParser("delete", new DeleteDefinitionParser());
        registerBeanDefinitionParser("find-objects", new FindObjectsDefinitionParser());
        registerBeanDefinitionParser("generate-a-new-request-id", new GenerateANewRequestIdDefinitionParser());
        registerBeanDefinitionParser("status", new StatusDefinitionParser());
        registerBeanDefinitionParser("sync-activity", new SyncActivityDefinitionParser());
    }

}
