
package org.mule.modules.quickbooks.windows.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.modules.quickbooks.windows.processors.GetObjectMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class GetObjectDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public GetObjectDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(GetObjectMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("realmId")!= null)&&(!StringUtils.isBlank(element.getAttribute("realmId")))) {
            builder.addPropertyValue("realmId", element.getAttribute("realmId"));
        }
        if ((element.getAttribute("appKey")!= null)&&(!StringUtils.isBlank(element.getAttribute("appKey")))) {
            builder.addPropertyValue("appKey", element.getAttribute("appKey"));
        }
        if ((element.getAttribute("realmIdPseudonym")!= null)&&(!StringUtils.isBlank(element.getAttribute("realmIdPseudonym")))) {
            builder.addPropertyValue("realmIdPseudonym", element.getAttribute("realmIdPseudonym"));
        }
        if ((element.getAttribute("authIdPseudonym")!= null)&&(!StringUtils.isBlank(element.getAttribute("authIdPseudonym")))) {
            builder.addPropertyValue("authIdPseudonym", element.getAttribute("authIdPseudonym"));
        }
        if (element.hasAttribute("type")) {
            builder.addPropertyValue("type", element.getAttribute("type"));
        }
        Element idListElement = null;
        idListElement = DomUtils.getChildElementByTagName(element, "id");
        List<Element> idMapChilds = null;
        if (idListElement!= null) {
            String idRef = idListElement.getAttribute("ref");
            if ((idRef!= null)&&(!StringUtils.isBlank(idRef))) {
                if ((!idRef.startsWith(patternInfo.getPrefix()))&&(!idRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("id", new RuntimeBeanReference(idRef));
                } else {
                    builder.addPropertyValue("id", idRef);
                }
            } else {
                ManagedMap id = new ManagedMap();
                idMapChilds = DomUtils.getChildElementsByTagName(idListElement, "id");
                if (idMapChilds!= null) {
                    if (idMapChilds.size() == 0) {
                        idMapChilds = DomUtils.getChildElements(idListElement);
                    }
                    for (Element idChild: idMapChilds) {
                        String idValueRef = idChild.getAttribute("value-ref");
                        String idKeyRef = idChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((idValueRef!= null)&&(!StringUtils.isBlank(idValueRef))) {
                            if ((!idValueRef.startsWith(patternInfo.getPrefix()))&&(!idValueRef.endsWith(patternInfo.getSuffix()))) {
                                valueObject = new RuntimeBeanReference(idValueRef);
                            } else {
                                valueObject = idValueRef;
                            }
                        } else {
                            valueObject = idChild.getTextContent();
                        }
                        if ((idKeyRef!= null)&&(!StringUtils.isBlank(idKeyRef))) {
                            keyObject = new RuntimeBeanReference(idKeyRef);
                        } else {
                            keyObject = idChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = idChild.getTagName();
                        }
                        id.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("id", id);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
