/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.iterators.thriter.AdvanceThriterator;
import net.sf.staccatocommons.iterators.thriter.Thriter;
import net.sf.staccatocommons.iterators.thriter.Thriterator;
import net.sf.staccatocommons.iterators.thriter.Thriterators;
import net.sf.staccatocommons.iterators.thriter.internal.ConstantThunk;

public class PrependThriterator<A>
extends AdvanceThriterator<A> {
    private final A element;
    private final Thriter<? extends A> iter;
    private boolean elementConsumed;
    private boolean iterAdvanced;

    public PrependThriterator(A element, Thriter<? extends A> iterator) {
        this.element = element;
        this.iter = iterator;
    }

    public PrependThriterator(A element, Iterator<? extends A> iterator) {
        this(element, (Thriter)Thriterators.from(iterator));
    }

    public PrependThriterator(A element, Thriterator<? extends A> iterator) {
        this((A)element, (Thriter<? extends A>)iterator);
    }

    @Override
    public final boolean hasNext() {
        return !this.elementConsumed || this.iter.hasNext();
    }

    @Override
    public final void advanceNext() throws NoSuchElementException {
        if (!this.elementConsumed) {
            this.elementConsumed = true;
        } else {
            this.iter.advanceNext();
            this.iterAdvanced = true;
        }
    }

    @Override
    public final A current() throws NoSuchElementException {
        if (this.iterAdvanced) {
            return this.iter.current();
        }
        return this.elementValue();
    }

    protected A elementValue() {
        return this.element;
    }

    protected Thunk<A> elementThunk() {
        return new ConstantThunk<A>(this.element);
    }

    @Override
    public Thunk<A> delayedCurrent() {
        if (this.iterAdvanced) {
            return this.iter.delayedCurrent();
        }
        return this.elementThunk();
    }
}

