/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.quickbooks.api;

import com.intuit.ipp.oauth.signing.RsaSha1MessageSigner;
import com.intuit.ipp.oauth.signing.XoAuthAuthorizationHeaderSigningStrategy;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.signature.OAuthMessageSigner;
import oauth.signpost.signature.SigningStrategy;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;
import org.mule.modules.quickbooks.api.exception.QuickBooksRuntimeException;
import org.mule.modules.quickbooks.api.gateway.MuleOAuthCredentialStorage;
import org.mule.modules.quickbooks.api.gateway.oauth.OAuthGateway;
import org.mule.modules.quickbooks.online.schema.FaultInfo;
import org.mule.modules.quickbooks.utils.MessageUtils;
import org.mule.modules.utils.MuleSoftException;
import org.springframework.core.io.ClassPathResource;

public abstract class AbstractQuickBooksClient {
    private static final String INTERNAL_GATEWAY_PROPS = "internal-gateway.properties";
    protected Properties properties;
    protected Integer resultsPerPage = 100;
    protected PrivateKey privateKey;
    protected String serviceProviderId;
    protected String baseUri;
    protected final HttpClient client = AbstractQuickBooksClient.getThreadSafeClient();
    private final Map<String, CompanyConnectionData> connectionDatas = new HashMap<String, CompanyConnectionData>();

    public static DefaultHttpClient getThreadSafeClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        ClientConnectionManager mgr = client.getConnectionManager();
        HttpParams params = client.getParams();
        client = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(params, mgr.getSchemeRegistry()), params);
        return client;
    }

    protected void init(String baseUri) {
        Validate.notEmpty((String)baseUri);
        this.baseUri = baseUri;
        try {
            this.loadProperties(INTERNAL_GATEWAY_PROPS);
            this.loadPrivateKey();
        }
        catch (Exception e) {
            throw MuleSoftException.soften((Throwable)e);
        }
    }

    private String getAccessTokensFromSaml(String appKey, String realmIdPseudonym, String authIdPseudonym) {
        String tokens = null;
        try {
            MuleOAuthCredentialStorage storage = new MuleOAuthCredentialStorage();
            storage.setConsumerKey(appKey);
            storage.setConsumerSecret("");
            tokens = new OAuthGateway(storage, (OAuthMessageSigner)new RsaSha1MessageSigner(this.privateKey), (SigningStrategy)new XoAuthAuthorizationHeaderSigningStrategy()).getOAuthToken(this.serviceProviderId, authIdPseudonym, realmIdPseudonym);
            return tokens.substring(tokens.indexOf("oauth_token=") + "oauth_token=".length());
        }
        catch (Exception e) {
            throw MuleSoftException.soften((Throwable)e);
        }
    }

    protected Object makeARequestToQuickbooks(HttpUriRequest httpRequest, String appKey, String accessToken) {
        CommonsHttpOAuthConsumer postConsumer = new CommonsHttpOAuthConsumer(appKey, "");
        postConsumer.setTokenWithSecret(accessToken, "");
        postConsumer.setMessageSigner((OAuthMessageSigner)new RsaSha1MessageSigner(this.privateKey));
        postConsumer.setSigningStrategy((SigningStrategy)new XoAuthAuthorizationHeaderSigningStrategy());
        try {
            postConsumer.sign((Object)httpRequest);
        }
        catch (Exception e) {
            throw MuleSoftException.soften((Throwable)e);
        }
        BufferedReader br = null;
        StringBuffer responseBody = null;
        HttpResponse response = null;
        int statusCode = 200;
        try {
            try {
                String readLine;
                response = this.client.execute(httpRequest);
                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                responseBody = new StringBuffer();
                while ((readLine = br.readLine()) != null) {
                    responseBody.append(String.valueOf(readLine) + System.getProperty("line.separator"));
                }
                statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    FaultInfo fault = this.getFaultInfo(responseBody.toString());
                    throw new QuickBooksRuntimeException(fault);
                }
            }
            catch (Exception e) {
                throw MuleSoftException.soften((Throwable)e);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    throw MuleSoftException.soften((Throwable)e);
                }
            }
        }
        try {
            return this.getMessageUtilsInstance().parseResponse(responseBody.toString());
        }
        catch (JAXBException e) {
            throw MuleSoftException.soften((Throwable)e);
        }
    }

    protected abstract FaultInfo getFaultInfo(String var1) throws JAXBException;

    protected abstract MessageUtils getMessageUtilsInstance();

    protected void prepareToPost(Object obj, HttpUriRequest httpRequest) {
        JAXBElement jaxbElement = this.getMessageUtilsInstance().createJaxbElement(obj);
        try {
            String documentToPost = this.getMessageUtilsInstance().getXmlDocument((JAXBElement<? extends Object>)jaxbElement);
            ByteArrayInputStream payLoad = new ByteArrayInputStream(documentToPost.getBytes());
            InputStreamEntity entity = new InputStreamEntity((InputStream)payLoad, -1L);
            ((HttpPost)httpRequest).setEntity((HttpEntity)entity);
        }
        catch (Exception e) {
            throw MuleSoftException.soften((Throwable)e);
        }
    }

    public void setResultsPerPage(Integer resultsPerPage) {
        if (resultsPerPage > 100 || resultsPerPage < 10) {
            throw new IllegalArgumentException("Results Per Page must be a number between 10 and 100");
        }
        this.resultsPerPage = resultsPerPage;
    }

    private void loadProperties(String resourceName) throws IOException {
        this.properties = new Properties();
        InputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new ClassPathResource(resourceName).getInputStream();
                this.properties.load(fileInputStream);
            }
            catch (Exception exception) {
                throw new IOException("Configuration resource " + resourceName + " not found");
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void loadPrivateKey() throws IOException {
        String keyStorePath = (String)this.properties.get("keystore.keystorePath");
        String keyStorePassword = (String)this.properties.get("keystore.password");
        String privateKeyPassword = (String)this.properties.get("keystore.privateKeyPassword");
        String privateKeyAlias = (String)this.properties.get("keystore.privateKeyAlias");
        String keyStoreType = (String)this.properties.get("keystore.keystoreType");
        this.serviceProviderId = (String)this.properties.get("serviceProviderId");
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(new ClassPathResource(keyStorePath).getInputStream(), keyStorePassword.toCharArray());
            this.privateKey = (PrivateKey)keyStore.getKey(privateKeyAlias, privateKeyPassword.toCharArray());
        }
        catch (Exception exception) {
            throw new IOException("Properties file with wrong configuration");
        }
    }

    protected abstract String loadCompanyBaseUri(String var1, String var2, String var3);

    protected String getBaseUri(String realmId) {
        return this.connectionDatas.get(realmId).getBaseUri();
    }

    protected String getAccessToken(String realmId) {
        return this.connectionDatas.get(realmId).getAccessToken();
    }

    protected void destroyAccessToken(String realmId) {
        this.connectionDatas.get(realmId).invalidateToken();
    }

    protected void loadCompanyData(String realmId, String appKey, String realmIdPseudonym, String authIdPseudonym) {
        if (!this.connectionDatas.containsKey(realmId) || !this.connectionDatas.get(realmId).isTokenValid()) {
            String accessToken = this.getAccessTokensFromSaml(appKey, realmIdPseudonym, authIdPseudonym);
            if (!this.connectionDatas.containsKey(realmId)) {
                this.connectionDatas.put(realmId, new CompanyConnectionData());
                this.connectionDatas.get(realmId).setBaseUri(this.loadCompanyBaseUri(realmId, appKey, accessToken));
            }
            this.connectionDatas.get(realmId).setAccessToken(accessToken);
        }
    }

    protected Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    private class CompanyConnectionData {
        private String baseUri;
        private String accessToken;

        protected CompanyConnectionData() {
            this.invalidateToken();
        }

        public String getBaseUri() {
            return this.baseUri;
        }

        public void setBaseUri(String baseUri) {
            this.baseUri = baseUri;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public void invalidateToken() {
            this.accessToken = "invalidToken";
        }

        public boolean isTokenValid() {
            return this.accessToken.equals("invalidToken");
        }
    }
}

