/*
 * Decompiled with CFR 0.152.
 */
package com.zauberlabs.commons.mom;

import java.lang.reflect.Method;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.stream.Streams;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.defs.predicate.Predicate;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate;
import net.sf.staccatocommons.lang.predicate.Predicates;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.check.NotEmpty;
import net.sf.staccatocommons.restrictions.processing.IgnoreRestrictions;
import net.sf.staccatocommons.util.Strings;
import org.apache.commons.lang.StringUtils;

public class NaiveProperties {
    private static final AbstractFunction METHOD_NAME = NaiveProperties.methodNameInitializer();

    public static Method getterOrNull(@NonNull Class<?> clazz, @NotEmpty String propertyName) {
        Ensure.that().isNotEmpty("var1", (CharSequence)propertyName);
        Ensure.isNotNull((String)"var0", clazz);
        String capitalizedName = StringUtils.capitalize((String)propertyName);
        return NaiveProperties.findMethodOrNull(clazz, 0, (Predicate<String>)Strings.matches((String)("(get|is)" + capitalizedName)));
    }

    @IgnoreRestrictions
    public static Method getter(@NonNull Class<?> clazz, @NotEmpty String propertyName) {
        Method getter = NaiveProperties.getterOrNull(clazz, propertyName);
        Ensure.that((getter != null ? 1 : 0) != 0, (String)"Property %s in class %s is not readable", (Object[])new Object[]{propertyName, clazz});
        return getter;
    }

    public static Method setterOrNull(@NonNull Class<?> clazz, @NotEmpty String propertyName) {
        Ensure.that().isNotEmpty("var1", (CharSequence)propertyName);
        Ensure.isNotNull((String)"var0", clazz);
        String capitalizedName = StringUtils.capitalize((String)propertyName);
        return NaiveProperties.findMethodOrNull(clazz, 1, (Predicate<String>)Predicates.equal((Object)("set" + capitalizedName)));
    }

    @IgnoreRestrictions
    public static Method setter(@NonNull Class<?> clazz, String propertyName) {
        Method setter = NaiveProperties.setterOrNull(clazz, propertyName);
        Ensure.that((setter != null ? 1 : 0) != 0, (String)"Property %s in class %s is not writable", (Object[])new Object[]{propertyName, clazz});
        return setter;
    }

    public static Method findMethodOrNull(@NonNull Class<?> clazz, int argsCount, Predicate<String> namePredicate) {
        Ensure.isNotNull((String)"var0", clazz);
        return (Method)Streams.cons((Object[])clazz.getMethods()).findOrNull(NaiveProperties.signature(argsCount, namePredicate));
    }

    public static Predicate<Method> signature(int argsCount, Predicate<String> namePredicate) {
        return NaiveProperties.argCount(argsCount).and((Evaluable)namePredicate.of(NaiveProperties.methodName()));
    }

    public static <T> T get(@NonNull Object destination, @NotEmpty String propertyName) {
        Ensure.that().isNotEmpty("var1", (CharSequence)propertyName);
        Ensure.isNotNull((String)"var0", (Object)destination);
        try {
            return (T)NaiveProperties.getter(destination.getClass(), propertyName).invoke(destination, new Object[0]);
        }
        catch (Exception e) {
            throw SoftException.soften((Throwable)e);
        }
    }

    public static void set(@NonNull Object destination, @NotEmpty String propertyName, Object propertyValue) {
        Ensure.that().isNotEmpty("var1", (CharSequence)propertyName);
        Ensure.isNotNull((String)"var0", (Object)destination);
        try {
            NaiveProperties.setter(destination.getClass(), propertyName).invoke(destination, propertyValue);
        }
        catch (Exception e) {
            throw SoftException.soften((Throwable)e);
        }
    }

    @Constant
    public static AbstractPredicate<Method> argCount(final int argsCount) {
        return new AbstractPredicate<Method>(){

            public boolean eval(Method arg0) {
                return arg0.getParameterTypes().length == argsCount;
            }
        };
    }

    @Constant
    public static AbstractFunction<Method, String> methodName() {
        return METHOD_NAME;
    }

    private static AbstractFunction methodNameInitializer() {
        return new AbstractFunction<Method, String>(){

            public String apply(Method arg0) {
                return arg0.getName();
            }
        };
    }
}

