/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.oauth.signing;

import oauth.signpost.OAuth;
import oauth.signpost.http.HttpParameters;
import oauth.signpost.http.HttpRequest;
import oauth.signpost.signature.SigningStrategy;

public class XoAuthAuthorizationHeaderSigningStrategy
implements SigningStrategy {
    private static final long serialVersionUID = 1L;

    public String writeSignature(String signature, HttpRequest request, HttpParameters requestParameters) {
        StringBuilder sb = new StringBuilder();
        sb.append("OAuth ");
        if (requestParameters.containsKey((Object)"realm")) {
            sb.append(requestParameters.getAsHeaderElement("realm"));
            sb.append(", ");
        }
        if (requestParameters.containsKey((Object)"oauth_token")) {
            sb.append(requestParameters.getAsHeaderElement("oauth_token"));
            sb.append(", ");
        }
        if (requestParameters.containsKey((Object)"oauth_callback")) {
            sb.append(requestParameters.getAsHeaderElement("oauth_callback"));
            sb.append(", ");
        }
        if (requestParameters.containsKey((Object)"oauth_verifier")) {
            sb.append(requestParameters.getAsHeaderElement("oauth_verifier"));
            sb.append(", ");
        }
        for (String key : requestParameters.keySet()) {
            if (!key.toLowerCase().startsWith("xoauth_")) continue;
            sb.append(requestParameters.getAsHeaderElement(key));
            sb.append(", ");
        }
        sb.append(requestParameters.getAsHeaderElement("oauth_consumer_key"));
        sb.append(", ");
        sb.append(requestParameters.getAsHeaderElement("oauth_version"));
        sb.append(", ");
        sb.append(requestParameters.getAsHeaderElement("oauth_signature_method"));
        sb.append(", ");
        sb.append(requestParameters.getAsHeaderElement("oauth_timestamp"));
        sb.append(", ");
        sb.append(requestParameters.getAsHeaderElement("oauth_nonce"));
        sb.append(", ");
        sb.append(OAuth.toHeaderElement((String)"oauth_signature", (String)signature));
        String header = sb.toString();
        request.setHeader("Authorization", header);
        return header;
    }
}

