/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.oauth.signing;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.http.HttpParameters;
import oauth.signpost.http.HttpRequest;
import oauth.signpost.signature.OAuthMessageSigner;
import oauth.signpost.signature.SignatureBaseString;

public class RsaSha1MessageSigner
extends OAuthMessageSigner {
    private PrivateKey privateKey;

    public RsaSha1MessageSigner(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String getSignatureMethod() {
        return "RSA-SHA1";
    }

    public String sign(HttpRequest request, HttpParameters requestParams) throws OAuthMessageSignerException {
        byte[] signedBytes;
        String sbs = new SignatureBaseString(request, requestParams).generate();
        try {
            byte[] keyBytes = sbs.getBytes("UTF-8");
            signedBytes = this.signBytes(keyBytes);
        }
        catch (InvalidKeyException e) {
            throw new OAuthMessageSignerException((Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OAuthMessageSignerException((Exception)e);
        }
        catch (SignatureException e) {
            throw new OAuthMessageSignerException((Exception)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuthMessageSignerException((Exception)e);
        }
        return this.base64Encode(signedBytes).trim();
    }

    private byte[] signBytes(byte[] keyBytes) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signer = Signature.getInstance("SHA1withRSA");
        signer.initSign(this.privateKey);
        signer.update(keyBytes);
        return signer.sign();
    }
}

