/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.ipp.oauth.helper;

import com.intuit.ipp.oauth.helper.OAuthHelperProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthProvider;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.exception.OAuthNotAuthorizedException;
import oauth.signpost.http.HttpParameters;
import oauth.signpost.signature.OAuthMessageSigner;
import oauth.signpost.signature.SigningStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;

public class OAuthHelper {
    private OAuthConsumer consumer;
    private OAuthProvider provider;
    OAuthHelperProvider client;

    public OAuthHelper(OAuthHelperProvider client) {
        this.client = client;
        this.consumer = new CommonsHttpOAuthConsumer(client.getConsumerKey(), client.getConsumerSecret());
        this.provider = new CommonsHttpOAuthProvider(client.getRequestTokenURL(), client.getAccessTokenURL(), client.getAuthorizeURL());
    }

    public OAuthHelper(OAuthHelperProvider client, OAuthMessageSigner messageSigner) {
        this(client);
        this.consumer.setMessageSigner(messageSigner);
    }

    public OAuthHelper(OAuthHelperProvider client, SigningStrategy signingStrategy) {
        this(client);
        this.consumer.setSigningStrategy(signingStrategy);
    }

    public OAuthHelper(OAuthHelperProvider client, OAuthMessageSigner messageSigner, SigningStrategy signingStrategy) {
        this(client);
        this.consumer.setMessageSigner(messageSigner);
        this.consumer.setSigningStrategy(signingStrategy);
    }

    public String GetAuthenticationURL() throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException {
        String authUrl = this.provider.retrieveRequestToken(this.consumer, this.client.getCallBackURL());
        this.client.storeRequestToken(this.consumer.getToken());
        this.client.storeRequestTokenSecret(this.consumer.getTokenSecret());
        return authUrl;
    }

    public void FinishAuthentication(String verifier) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException {
        String requestToken = this.client.restoreRequestToken();
        String requestTokenSecret = this.client.restoreRequestTokenSecret();
        this.consumer.setTokenWithSecret(requestToken, requestTokenSecret);
        this.provider.setOAuth10a(true);
        this.provider.retrieveAccessToken(this.consumer, verifier);
        String token = this.consumer.getToken();
        String tokenSecret = this.consumer.getTokenSecret();
        this.client.storeToken(token);
        this.client.storeTokenSecret(tokenSecret);
    }

    public OAuthConsumer getConsumer() {
        if (this.client.isAuthenticated() && this.consumer.getToken() == null || this.consumer.getTokenSecret() == null) {
            this.consumer.setTokenWithSecret(this.client.restoreToken(), this.client.restoreTokenSecret());
        }
        return this.consumer;
    }

    public static String getUrlContentSigned(OAuthConsumer consumer, String url, HttpParameters additionalParameters) {
        String str = "";
        try {
            String line;
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpGet request = new HttpGet(url);
            consumer.setAdditionalParameters(additionalParameters);
            consumer.sign((Object)request);
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            InputStream is = response.getEntity().getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                str = str + "\n" + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public static String getUrlContentSigned(OAuthConsumer consumer, String url) {
        return OAuthHelper.getUrlContentSigned(consumer, url, null);
    }

    public static String getUrlContentUnsigned(String url) throws ClientProtocolException, IOException {
        String line;
        String str = "";
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet request = new HttpGet(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        InputStream is = response.getEntity().getContent();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        while ((line = reader.readLine()) != null) {
            str = str + "\n" + line;
        }
        return str;
    }

    public static String postUrlContentSigned(OAuthConsumer consumer, String url, String content) {
        String str = "";
        try {
            String line;
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpPost request = new HttpPost(url);
            request.setEntity((HttpEntity)new StringEntity(content));
            consumer.sign((Object)request);
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            InputStream is = response.getEntity().getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                str = str + "\n" + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }
}

