/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.quickbooks.online.transformers;

import java.math.BigInteger;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class StringToBigIntegerTransformer
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;

    public StringToBigIntegerTransformer() {
        this.registerSourceType(DataTypeFactory.create(String.class));
        this.setReturnClass(BigInteger.class);
        this.setName("StringToBigIntegerTransformer");
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            return new BigInteger((String)src);
        }
        catch (NumberFormatException e) {
            throw new TransformerException(MessageFactory.createStaticMessage((String)String.format("Could not parse %s to a big integer", src)), (Transformer)this, (Throwable)e);
        }
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int value) {
        this.priorityWeighting = value;
    }
}

