/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.quickbooks.online.objectfactory;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.mule.modules.quickbooks.online.objectfactory.ObjectFactory;
import org.mule.modules.quickbooks.utils.MessageUtils;

public class QBOMessageUtils
extends MessageUtils {
    private static QBOMessageUtils qboMessageUtils = null;

    private QBOMessageUtils() {
    }

    public static QBOMessageUtils getInstance() {
        if (qboMessageUtils == null) {
            qboMessageUtils = new QBOMessageUtils();
        }
        return qboMessageUtils;
    }

    protected JAXBContext getJaxbContext() {
        return QBOMessageUtilsHelper.getContext();
    }

    protected Object getObjectFactory() {
        return QBOMessageUtilsHelper.getObjectFactory();
    }

    public Object parseResponse(String responseString) throws JAXBException {
        Unmarshaller unmarshaller = this.createUnmarshaller();
        Object unmarshalledObject = unmarshaller.unmarshal((Reader)new StringReader(responseString));
        JAXBElement jaxb = (JAXBElement)unmarshalledObject;
        return jaxb.getValue();
    }

    private static class QBOMessageUtilsHelper {
        private static ObjectFactory objectFactory = new ObjectFactory();
        private static JAXBContext privContext = null;

        private QBOMessageUtilsHelper() {
        }

        public static JAXBContext getContext() {
            if (privContext == null) {
                try {
                    privContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
                }
                catch (JAXBException e) {
                    throw new RuntimeException(e);
                }
            }
            return privContext;
        }

        public static Object getObjectFactory() {
            return objectFactory;
        }
    }
}

