/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.quickbooks.online.api;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.mule.modules.quickbooks.api.AbstractQuickBooksClientOAuth;
import org.mule.modules.quickbooks.api.QuickBooksConventions;
import org.mule.modules.quickbooks.api.exception.ExceptionInfo;
import org.mule.modules.quickbooks.api.exception.QuickBooksRuntimeException;
import org.mule.modules.quickbooks.api.model.AppMenuInformation;
import org.mule.modules.quickbooks.api.model.PlatformResponse;
import org.mule.modules.quickbooks.api.model.ReconnectResponse;
import org.mule.modules.quickbooks.api.model.UserInformation;
import org.mule.modules.quickbooks.api.model.UserResponse;
import org.mule.modules.quickbooks.api.oauth.OAuthCredentials;
import org.mule.modules.quickbooks.online.OnlineEntityType;
import org.mule.modules.quickbooks.online.api.QuickBooksOnlineClient;
import org.mule.modules.quickbooks.online.objectfactory.QBOMessageUtils;
import org.mule.modules.quickbooks.online.schema.CdmBase;
import org.mule.modules.quickbooks.online.schema.IdType;
import org.mule.modules.quickbooks.online.schema.QboUser;
import org.mule.modules.quickbooks.online.schema.SearchResults;
import org.mule.modules.quickbooks.utils.MessageUtils;
import org.mule.modules.utils.MuleSoftException;
import org.mule.modules.utils.pagination.PaginatedIterable;

public class DefaultQuickBooksOnlineClient
extends AbstractQuickBooksClientOAuth
implements QuickBooksOnlineClient {
    public DefaultQuickBooksOnlineClient(String baseUri, String consumerKey, String consumerSecret, String appKey) {
        Validate.notEmpty((String)baseUri);
        this.init(baseUri, consumerKey, consumerSecret, appKey);
        this.setResultsPerPage(100);
    }

    @Override
    public <T extends CdmBase> T create(OAuthCredentials credentials, T obj) {
        Validate.notNull(obj);
        String str = String.format("%s/resource/%s/v2/%s", credentials.getBaseUri(), QuickBooksConventions.toQuickBooksPathVariable((String)obj.getClass().getSimpleName()), credentials.getRealmId());
        HttpPost httpRequest = new HttpPost(str);
        httpRequest.addHeader("Content-Type", "application/xml");
        this.prepareToPost(obj, (HttpUriRequest)httpRequest);
        try {
            return (T)((CdmBase)this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, credentials, false));
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                this.destroyAccessToken(credentials);
                return this.create(credentials, obj);
            }
            throw e;
        }
    }

    @Override
    public <T extends CdmBase> T getObject(OAuthCredentials credentials, OnlineEntityType type, IdType id) {
        Validate.notNull((Object)((Object)type));
        Validate.notNull((Object)id);
        String str = String.format("%s/resource/%s/v2/%s/%s", credentials.getBaseUri(), type.getResouceName(), credentials.getRealmId(), id.getValue());
        HttpGet httpRequest = new HttpGet(str);
        try {
            return (T)((CdmBase)this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, credentials, false));
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                this.destroyAccessToken(credentials);
                return this.getObject(credentials, type, id);
            }
            throw e;
        }
    }

    @Override
    public <T extends CdmBase> T update(OAuthCredentials credentials, OnlineEntityType type, T obj) {
        Validate.notNull(obj);
        if (obj.getSyncToken() == null) {
            obj.setSyncToken(((CdmBase)this.getObject(credentials, type, obj.getId())).getSyncToken());
        }
        String str = String.format("%s/resource/%s/v2/%s/%s", credentials.getBaseUri(), QuickBooksConventions.toQuickBooksPathVariable((String)obj.getClass().getSimpleName()), credentials.getRealmId(), obj.getId().getValue());
        HttpPost httpRequest = new HttpPost(str);
        httpRequest.addHeader("Content-Type", "application/xml");
        this.prepareToPost(obj, (HttpUriRequest)httpRequest);
        try {
            return (T)((CdmBase)this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, credentials, false));
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                this.destroyAccessToken(credentials);
                return this.update(credentials, type, obj);
            }
            throw e;
        }
    }

    @Override
    public <T extends CdmBase> void deleteObject(OAuthCredentials credentials, OnlineEntityType type, IdType id, String syncToken) {
        Validate.notNull((Object)((Object)type));
        Validate.notNull((Object)id);
        if (syncToken == null) {
            syncToken = ((CdmBase)this.getObject(credentials, type, id)).getSyncToken();
        }
        CdmBase obj = (CdmBase)type.newInstance();
        obj.setSyncToken(syncToken);
        obj.setId(id);
        String str = String.format("%s/resource/%s/v2/%s/%s?methodx=delete", credentials.getBaseUri(), type.getResouceName(), credentials.getRealmId(), id.getValue());
        HttpPost httpRequest = new HttpPost(str);
        httpRequest.addHeader("Content-Type", "application/xml");
        this.prepareToPost(obj, (HttpUriRequest)httpRequest);
        try {
            this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, credentials, false);
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                this.destroyAccessToken(credentials);
                this.deleteObject(credentials, type, id, syncToken);
            }
            throw e;
        }
    }

    @Override
    public <T extends CdmBase> Iterable<T> findObjectsGetPages(final OAuthCredentials credentials, final OnlineEntityType type, final String queryFilter, final String querySort) {
        Validate.notNull((Object)((Object)type));
        return new PaginatedIterable<T, SearchResults>(){

            protected SearchResults firstPage() {
                return this.askAnEspecificPage(1);
            }

            protected SearchResults nextPage(SearchResults currentPage) {
                return this.askAnEspecificPage(currentPage.getCurrentPage() + 1);
            }

            protected boolean hasNextPage(SearchResults page) {
                return page.getCount().equals(DefaultQuickBooksOnlineClient.this.getResultsPerPage());
            }

            protected Iterator<T> pageIterator(SearchResults page) {
                try {
                    return ((List)page.getCdmCollections().getClass().getMethod("get" + type.getCdmCollectionName(), new Class[0]).invoke((Object)page.getCdmCollections(), new Object[0])).iterator();
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
                catch (InvocationTargetException e) {
                    throw new AssertionError((Object)e);
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)e);
                }
            }

            private SearchResults askAnEspecificPage(Integer pageNumber) {
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                if (queryFilter != null) {
                    nameValuePairs.add(new BasicNameValuePair("Filter", queryFilter));
                }
                if (querySort != null) {
                    nameValuePairs.add(new BasicNameValuePair("Sort", querySort));
                }
                nameValuePairs.add(new BasicNameValuePair("ResultsPerPage", DefaultQuickBooksOnlineClient.this.getResultsPerPage().toString()));
                nameValuePairs.add(new BasicNameValuePair("PageNum", pageNumber.toString()));
                HttpPost httpRequest = new HttpPost(String.format("%s/resource/%s/v2/%s", credentials.getBaseUri(), type.getResouceNameForFind(), credentials.getRealmId()));
                httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                try {
                    httpRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw MuleSoftException.soften((Throwable)e);
                }
                try {
                    return (SearchResults)DefaultQuickBooksOnlineClient.this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, credentials, false);
                }
                catch (QuickBooksRuntimeException e) {
                    if (e.isAExpiredTokenFault()) {
                        DefaultQuickBooksOnlineClient.this.destroyAccessToken(credentials);
                        return this.askAnEspecificPage(pageNumber);
                    }
                    throw e;
                }
            }
        };
    }

    @Override
    public <T extends CdmBase> Iterable<T> findObjects(OAuthCredentials credentials, OnlineEntityType type, String queryFilter, String querySort) {
        Validate.notNull((Object)((Object)type));
        ArrayList listOfResults = new ArrayList();
        Integer pageNumber = 0;
        Boolean hasMoreResults = true;
        while (hasMoreResults.booleanValue()) {
            SearchResults searchResults;
            Integer n = pageNumber;
            Integer n2 = pageNumber = Integer.valueOf(pageNumber + 1);
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            if (queryFilter != null) {
                nameValuePairs.add(new BasicNameValuePair("Filter", queryFilter));
            }
            if (querySort != null) {
                nameValuePairs.add(new BasicNameValuePair("Sort", querySort));
            }
            nameValuePairs.add(new BasicNameValuePair("ResultsPerPage", this.getResultsPerPage().toString()));
            nameValuePairs.add(new BasicNameValuePair("PageNum", pageNumber.toString()));
            HttpPost httpRequest = new HttpPost(String.format("%s/resource/%s/v2/%s", credentials.getBaseUri(), type.getResouceNameForFind(), credentials.getRealmId()));
            httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            try {
                httpRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw MuleSoftException.soften((Throwable)e);
            }
            try {
                searchResults = (SearchResults)this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, credentials, false);
            }
            catch (QuickBooksRuntimeException e) {
                if (e.isAExpiredTokenFault()) {
                    this.destroyAccessToken(credentials);
                    searchResults = (SearchResults)this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, credentials, false);
                }
                throw e;
            }
            hasMoreResults = searchResults.getCount() >= this.getResultsPerPage();
            try {
                listOfResults.addAll((List)searchResults.getCdmCollections().getClass().getMethod("get" + type.getCdmCollectionName(), new Class[0]).invoke((Object)searchResults.getCdmCollections(), new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
        return listOfResults;
    }

    @Override
    public String getCompanyBaseUri(OAuthCredentials credentials) {
        HttpGet httpRequest = new HttpGet(String.format("%s/%s", this.baseUri, credentials.getRealmId()));
        QboUser qboUser = (QboUser)this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, credentials, false);
        return qboUser.getCurrentCompany().getBaseURI();
    }

    protected ExceptionInfo getFaultInfo(String str) throws JAXBException {
        return new ExceptionInfo(this.getMessageUtilsInstance().parseResponse(str));
    }

    protected MessageUtils getMessageUtilsInstance() {
        return QBOMessageUtils.getInstance();
    }

    @Override
    public UserInformation getCurrentUserInformation(OAuthCredentials credentials) {
        return ((UserResponse)this.retrieveUserInformation(credentials)).getUser();
    }

    @Override
    public List<AppMenuInformation> getBlueDotInformation(OAuthCredentials credentials, String regex) {
        String blueDotInformation = (String)this.getBlueDotMenu(credentials);
        ArrayList<AppMenuInformation> menuInformationList = new ArrayList<AppMenuInformation>();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(blueDotInformation);
        while (matcher.find()) {
            AppMenuInformation info = new AppMenuInformation();
            String[] parameters = StringUtils.split((String)matcher.group(1), (String)",");
            info.setAppId(StringUtils.trim((String)StringUtils.remove((String)parameters[0], (String)"'")));
            info.setName(StringUtils.trim((String)StringUtils.remove((String)parameters[1], (String)"'")));
            info.setContentArea(StringUtils.trim((String)StringUtils.remove((String)parameters[2], (String)"'")));
            info.setImageUrl(StringUtils.trim((String)matcher.group(2)));
            menuInformationList.add(info);
        }
        return menuInformationList;
    }

    @Override
    public boolean disconnect(OAuthCredentials credentials) {
        PlatformResponse response = (PlatformResponse)this.disconnectFromQB(credentials);
        if (response.getErrorCode() != 0) {
            throw new QuickBooksRuntimeException(response.getErrorMessage());
        }
        return true;
    }

    @Override
    public OAuthCredentials reconnect(OAuthCredentials credentials) {
        ReconnectResponse response = (ReconnectResponse)this.reconnectToQB(credentials);
        if (response.getErrorCode() != 0) {
            throw new QuickBooksRuntimeException(response.getErrorMessage());
        }
        credentials.setAccessToken(response.getAccessToken());
        credentials.setAccessTokenSecret(response.getAccessTokenSecret());
        return credentials;
    }

    @Override
    public <T> T get(OAuthCredentials credentials, OnlineEntityType type) {
        Validate.notNull((Object)((Object)type));
        String str = String.format("%s/resource/%s/v2/%s", credentials.getBaseUri(), type.getResouceName(), credentials.getRealmId());
        HttpGet httpRequest = new HttpGet(str);
        try {
            return (T)this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, credentials, false);
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                this.destroyAccessToken(credentials);
                return this.get(credentials, type);
            }
            throw e;
        }
    }
}

