/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.quickbooks.online;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.exception.OAuthNotAuthorizedException;
import oauth.signpost.signature.HmacSha1MessageSigner;
import oauth.signpost.signature.OAuthMessageSigner;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleMessage;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.modules.quickbooks.api.ObjectStoreHelper;
import org.mule.modules.quickbooks.api.exception.QuickBooksRuntimeException;
import org.mule.modules.quickbooks.api.model.AppMenuInformation;
import org.mule.modules.quickbooks.api.model.UserInformation;
import org.mule.modules.quickbooks.api.oauth.DefaultQuickbooksOAuthClient;
import org.mule.modules.quickbooks.api.oauth.OAuthCredentials;
import org.mule.modules.quickbooks.api.openid.DefaultOpenIDClient;
import org.mule.modules.quickbooks.api.openid.OpenIDCredentials;
import org.mule.modules.quickbooks.online.OnlineEntityType;
import org.mule.modules.quickbooks.online.api.DefaultQuickBooksOnlineClient;
import org.mule.modules.quickbooks.online.api.QuickBooksOnlineClient;
import org.mule.modules.quickbooks.online.schema.Account;
import org.mule.modules.quickbooks.online.schema.Bill;
import org.mule.modules.quickbooks.online.schema.BillPayment;
import org.mule.modules.quickbooks.online.schema.CashPurchase;
import org.mule.modules.quickbooks.online.schema.Check;
import org.mule.modules.quickbooks.online.schema.CreditCardCharge;
import org.mule.modules.quickbooks.online.schema.Customer;
import org.mule.modules.quickbooks.online.schema.Estimate;
import org.mule.modules.quickbooks.online.schema.IdType;
import org.mule.modules.quickbooks.online.schema.Invoice;
import org.mule.modules.quickbooks.online.schema.Item;
import org.mule.modules.quickbooks.online.schema.Payment;
import org.mule.modules.quickbooks.online.schema.PaymentMethod;
import org.mule.modules.quickbooks.online.schema.SalesReceipt;
import org.mule.modules.quickbooks.online.schema.SalesTerm;
import org.mule.modules.quickbooks.online.schema.Vendor;
import org.openid4java.message.MessageException;

@Module(name="quickbooks", schemaVersion="4.0", friendlyName="Quickbooks Online")
public class QuickBooksModule {
    @Configurable
    private String consumerKey;
    @Configurable
    private String consumerSecret;
    @Configurable
    @Optional
    @Default(value="_defaultUserObjectStore")
    private ObjectStore objectStore;
    private ObjectStoreHelper objectStoreHelper;
    @Configurable
    @Optional
    private QuickBooksOnlineClient client;
    @Optional
    @Default(value="https://qbo.intuit.com/qbo1/rest/user/v2")
    @Configurable
    private String baseUri;
    @Configurable
    @Optional
    private String accessTokenIdentifierPrefix;
    @Configurable
    @Optional
    @Default(value="true")
    private boolean verifyOpenIdResponse;

    @Processor
    public Account createAccount(String accessTokenId, @Optional @Default(value="#[payload]") Account account) {
        return this.client.create(this.getAccessTokenInformation(accessTokenId), account);
    }

    @Processor
    public Bill createBill(String accessTokenId, @Optional @Default(value="#[payload]") Bill bill) {
        return this.client.create(this.getAccessTokenInformation(accessTokenId), bill);
    }

    @Processor
    public BillPayment createBillPayment(String accessTokenId, @Optional @Default(value="#[payload]") BillPayment billPayment) {
        return this.client.create(this.getAccessTokenInformation(accessTokenId), billPayment);
    }

    @Processor
    public CashPurchase createCashPurchase(String accessTokenId, @Optional @Default(value="#[payload]") CashPurchase cashPurchase) {
        return this.client.create(this.getAccessTokenInformation(accessTokenId), cashPurchase);
    }

    @Processor
    public Check createCheck(String accessTokenId, @Optional @Default(value="#[payload]") Check check) {
        return this.client.create(this.getAccessTokenInformation(accessTokenId), check);
    }

    @Processor
    public CreditCardCharge createCreditCardCharge(String accessTokenId, @Optional @Default(value="#[payload]") CreditCardCharge creditCardCharge) {
        return this.client.create(this.getAccessTokenInformation(accessTokenId), creditCardCharge);
    }

    @Processor
    public Customer createCustomer(String accessTokenId, @Optional @Default(value="#[payload]") Customer customer) {
        if (customer.getPaymentMethodId() != null && (customer.getPaymentMethodId().getValue().isEmpty() || StringUtils.isEmpty((String)customer.getPaymentMethodId().getValue()))) {
            customer.setPaymentMethodId(new IdType());
        }
        return this.client.create(this.getAccessTokenInformation(accessTokenId), customer);
    }

    @Processor
    public Estimate createEstimate(String accessTokenId, @Optional @Default(value="#[payload]") Estimate estimate) {
        return this.client.create(this.getAccessTokenInformation(accessTokenId), estimate);
    }

    @Processor
    public Invoice createInvoice(String accessTokenId, @Optional @Default(value="#[payload]") Invoice invoice) {
        return this.client.create(this.getAccessTokenInformation(accessTokenId), invoice);
    }

    @Processor
    public Item createItem(String accessTokenId, @Optional @Default(value="#[payload]") Item item) {
        return this.client.create(this.getAccessTokenInformation(accessTokenId), item);
    }

    @Processor
    public Payment createPayment(String accessTokenId, @Optional @Default(value="#[payload]") Payment payment) {
        return this.client.create(this.getAccessTokenInformation(accessTokenId), payment);
    }

    @Processor
    public PaymentMethod createPaymentMethod(String accessTokenId, @Optional @Default(value="#[payload]") PaymentMethod paymentMethod) {
        return this.client.create(this.getAccessTokenInformation(accessTokenId), paymentMethod);
    }

    @Processor
    public SalesReceipt createSalesReceipt(String accessTokenId, @Optional @Default(value="#[payload]") SalesReceipt salesReceipt) {
        return this.client.create(this.getAccessTokenInformation(accessTokenId), salesReceipt);
    }

    @Processor
    public SalesTerm createSalesTerm(String accessTokenId, @Optional @Default(value="#[payload]") SalesTerm salesTerm) {
        return this.client.create(this.getAccessTokenInformation(accessTokenId), salesTerm);
    }

    @Processor
    public Vendor createVendor(String accessTokenId, @Optional @Default(value="#[payload]") Vendor vendor) {
        return this.client.create(this.getAccessTokenInformation(accessTokenId), vendor);
    }

    @Processor
    public Object getObject(String accessTokenId, OnlineEntityType type, @Optional @Default(value="#[payload]") IdType id) {
        return this.client.getObject(this.getAccessTokenInformation(accessTokenId), type, id);
    }

    @Processor
    public Account updateAccount(String accessTokenId, @Optional @Default(value="#[payload]") Account account) {
        return this.client.update(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.ACCOUNT, account);
    }

    @Processor
    public Bill updateBill(String accessTokenId, @Optional @Default(value="#[payload]") Bill bill) {
        return this.client.update(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.BILL, bill);
    }

    @Processor
    public BillPayment updateBillPayment(String accessTokenId, @Optional @Default(value="#[payload]") BillPayment billPayment) {
        return this.client.update(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.BILLPAYMENT, billPayment);
    }

    @Processor
    public CashPurchase updateCashPurchase(String accessTokenId, @Optional @Default(value="#[payload]") CashPurchase cashPurchase) {
        return this.client.update(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.CASHPURCHASE, cashPurchase);
    }

    @Processor
    public Check updateCheck(String accessTokenId, @Optional @Default(value="#[payload]") Check check) {
        return this.client.update(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.CHECK, check);
    }

    @Processor
    public CreditCardCharge updateCreditCardCharge(String accessTokenId, @Optional @Default(value="#[payload]") CreditCardCharge creditCardCharge) {
        return this.client.update(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.CREDITCARDCHARGE, creditCardCharge);
    }

    @Processor
    public Customer updateCustomer(String accessTokenId, @Optional @Default(value="#[payload]") Customer customer) {
        if (customer.getPaymentMethodId() != null && (customer.getPaymentMethodId().getValue().isEmpty() || StringUtils.isEmpty((String)customer.getPaymentMethodId().getValue()))) {
            customer.setPaymentMethodId(new IdType());
        }
        return this.client.update(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.CUSTOMER, customer);
    }

    @Processor
    public Estimate updateEstimate(String accessTokenId, @Optional @Default(value="#[payload]") Estimate estimate) {
        return this.client.update(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.ESTIMATE, estimate);
    }

    @Processor
    public Invoice updateInvoice(String accessTokenId, @Optional @Default(value="#[payload]") Invoice invoice) {
        return this.client.update(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.INVOICE, invoice);
    }

    @Processor
    public Item updateItem(String accessTokenId, @Optional @Default(value="#[payload]") Item item) {
        return this.client.update(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.ITEM, item);
    }

    @Processor
    public Payment updatePayment(String accessTokenId, @Optional @Default(value="#[payload]") Payment payment) {
        return this.client.update(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.PAYMENT, payment);
    }

    @Processor
    public PaymentMethod updatePaymentMethod(String accessTokenId, @Optional @Default(value="#[payload]") PaymentMethod paymentMethod) {
        return this.client.update(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.PAYMENTMETHOD, paymentMethod);
    }

    @Processor
    public SalesReceipt updateSalesReceipt(String accessTokenId, @Optional @Default(value="#[payload]") SalesReceipt salesReceipt) {
        return this.client.update(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.SALESRECEIPT, salesReceipt);
    }

    @Processor
    public SalesTerm updateSalesTerm(String accessTokenId, @Optional @Default(value="#[payload]") SalesTerm salesTerm) {
        return this.client.update(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.SALESTERM, salesTerm);
    }

    @Processor
    public Vendor updateVendor(String accessTokenId, @Optional @Default(value="#[payload]") Vendor vendor) {
        return this.client.update(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.VENDOR, vendor);
    }

    @Processor
    public void deleteObject(String accessTokenId, OnlineEntityType type, @Optional @Default(value="#[payload]") IdType id, @Optional String syncToken) {
        this.client.deleteObject(this.getAccessTokenInformation(accessTokenId), type, id, syncToken);
    }

    @Processor
    public Iterable findObjects(String accessTokenId, OnlineEntityType type, @Optional String queryFilter, @Optional String querySort) {
        return this.client.findObjects(this.getAccessTokenInformation(accessTokenId), type, queryFilter, querySort);
    }

    @Processor
    public Iterable changeDataDeleted(String accessTokenId, @Optional String queryFilter, @Optional String querySort) {
        return this.client.findObjects(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.CHANGEDATADELETED, queryFilter, querySort);
    }

    @Processor
    public UserInformation getCurrentUser(String accessTokenId) {
        return this.client.getCurrentUserInformation(this.getAccessTokenInformation(accessTokenId));
    }

    @Processor
    public Object getCompanyMetadata(String accessTokenId) {
        return this.client.get(this.getAccessTokenInformation(accessTokenId), OnlineEntityType.COMPANY_METADATA);
    }

    @Processor
    public String authUser(String requestTokenUrl, String accessTokenUrl, String authorizationUrl, String callbackUrl, @Optional String requestTokenId, @OutboundHeaders Map<String, Object> headers) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException, ObjectStoreException {
        String authUrl = new DefaultQuickbooksOAuthClient(this.getConsumerKey(), this.getConsumerSecret(), this.getObjectStore()).authorize(requestTokenUrl, accessTokenUrl, authorizationUrl, callbackUrl, requestTokenId, (OAuthMessageSigner)new HmacSha1MessageSigner());
        headers.put("Location", authUrl);
        headers.put("http.status", "302");
        return authUrl;
    }

    @Processor
    public OAuthCredentials getAccessToken(@Optional String apiUrl, @Optional @Default(value="#[message.inboundProperties.oauth_verifier]") String verifier, @Optional @Default(value="#[message.inboundProperties.userId]") String requestTokenId, @Optional @Default(value="#[message.inboundProperties.realmId]") String userIdentifier) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException, ObjectStoreException {
        OAuthCredentials credentials = new DefaultQuickbooksOAuthClient(this.getConsumerKey(), this.getConsumerSecret(), this.getObjectStore()).getAccessToken(verifier, requestTokenId, (OAuthMessageSigner)new HmacSha1MessageSigner());
        credentials.setUserId(userIdentifier);
        credentials.setRealmId(userIdentifier);
        if (StringUtils.isNotBlank((String)apiUrl)) {
            credentials.setBaseUri(apiUrl);
        } else {
            credentials.setBaseUri(this.client.getCompanyBaseUri(credentials));
        }
        if (StringUtils.isNotEmpty((String)this.getAccessTokenIdentifierPrefix())) {
            userIdentifier = this.getAccessTokenIdentifierPrefix() + userIdentifier;
        }
        this.getObjectStoreHelper().store(userIdentifier, (Serializable)credentials, true);
        return credentials;
    }

    @Processor
    public String openIdInitialize(@Optional @Default(value="https://openid.intuit.com/OpenId/Provider") String providerUrl, String callbackUrl, @OutboundHeaders Map<String, Object> headers) throws ObjectStoreException {
        String url = new DefaultOpenIDClient(this.getObjectStoreHelper()).initialize(providerUrl, callbackUrl, this.getVerifyOpenIdResponse());
        headers.put("Location", url);
        headers.put("http.status", "302");
        return url;
    }

    @Processor
    @Inject
    public OpenIDCredentials verifyOpenId(MuleMessage muleMessage, @Optional String receivingUrl, @Optional @Default(value="#[header:INBOUND:http.query.params]") Map<String, String> responseParameters) throws MessageException, ObjectStoreException {
        if (StringUtils.isEmpty((String)receivingUrl)) {
            receivingUrl = String.format("%s%s%s", muleMessage.getInboundProperty("http.context.uri"), "?", muleMessage.getInboundProperty("http.query.string"));
        }
        return new DefaultOpenIDClient(this.getObjectStoreHelper()).verifyOpenIDFromIntuit(receivingUrl, responseParameters, this.getVerifyOpenIdResponse());
    }

    @Processor
    public List<AppMenuInformation> getBlueDotInformation(String accessTokenId, @Optional @Default(value="intuitPlatformOpenOtherApp\\((.+?)\\)\" style='background-image: url\\((.+?)\\)") String regex) {
        return this.client.getBlueDotInformation(this.getAccessTokenInformation(accessTokenId), regex);
    }

    @Processor
    public boolean disconnect(String accessTokenId) {
        return this.client.disconnect(this.getAccessTokenInformation(accessTokenId));
    }

    @Processor
    public void reconnect(String accessTokenId) throws ObjectStoreException {
        OAuthCredentials creds = this.client.reconnect(this.getAccessTokenInformation(accessTokenId));
        this.getObjectStoreHelper().store(creds.getUserId(), (Serializable)creds, true);
    }

    private OAuthCredentials getAccessTokenInformation(String accessTokenIdentifier) {
        if (StringUtils.isNotEmpty((String)this.getAccessTokenIdentifierPrefix())) {
            accessTokenIdentifier = this.getAccessTokenIdentifierPrefix() + accessTokenIdentifier;
        }
        try {
            return (OAuthCredentials)this.objectStoreHelper.retrieve(accessTokenIdentifier);
        }
        catch (ObjectDoesNotExistException e) {
            throw new QuickBooksRuntimeException(String.format("The user token could not be retrieved from the Object Store using the key %s. It seems the user is not authenticated, please start OAuth dance again", accessTokenIdentifier));
        }
        catch (ObjectStoreException e) {
            throw new QuickBooksRuntimeException("The user token could not be retrieved: " + e.getMessage());
        }
    }

    private OAuthCredentials createCredentials(String accessToken, String accessTokenSecret) {
        return new OAuthCredentials(accessToken, accessTokenSecret);
    }

    @PostConstruct
    public void init() {
        if (this.client == null) {
            this.client = new DefaultQuickBooksOnlineClient(this.baseUri, this.consumerKey, this.consumerSecret, "");
            this.setObjectStoreHelper(new ObjectStoreHelper(this.objectStore));
        }
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public QuickBooksOnlineClient getClient() {
        return this.client;
    }

    public void setClient(QuickBooksOnlineClient client) {
        this.client = client;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStore = objectStore;
    }

    public ObjectStoreHelper getObjectStoreHelper() {
        return this.objectStoreHelper;
    }

    public void setObjectStoreHelper(ObjectStoreHelper objectStoreHelper) {
        this.objectStoreHelper = objectStoreHelper;
    }

    public String getAccessTokenIdentifierPrefix() {
        return this.accessTokenIdentifierPrefix;
    }

    public void setAccessTokenIdentifierPrefix(String accessTokenIdentifierPrefix) {
        this.accessTokenIdentifierPrefix = accessTokenIdentifierPrefix;
    }

    public boolean getVerifyOpenIdResponse() {
        return this.verifyOpenIdResponse;
    }

    public void setVerifyOpenIdResponse(boolean verifyOpenIdResponse) {
        this.verifyOpenIdResponse = verifyOpenIdResponse;
    }
}

