/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.quickbooks.online;

import org.mule.modules.quickbooks.api.QuickBooksConventions;
import org.mule.modules.quickbooks.online.schema.Account;
import org.mule.modules.quickbooks.online.schema.Bill;
import org.mule.modules.quickbooks.online.schema.BillPayment;
import org.mule.modules.quickbooks.online.schema.CashPurchase;
import org.mule.modules.quickbooks.online.schema.Check;
import org.mule.modules.quickbooks.online.schema.CompanyMetaData;
import org.mule.modules.quickbooks.online.schema.CreditCardCharge;
import org.mule.modules.quickbooks.online.schema.Customer;
import org.mule.modules.quickbooks.online.schema.DeletedEntities;
import org.mule.modules.quickbooks.online.schema.Estimate;
import org.mule.modules.quickbooks.online.schema.Invoice;
import org.mule.modules.quickbooks.online.schema.Item;
import org.mule.modules.quickbooks.online.schema.Payment;
import org.mule.modules.quickbooks.online.schema.PaymentMethod;
import org.mule.modules.quickbooks.online.schema.SalesReceipt;
import org.mule.modules.quickbooks.online.schema.SalesTerm;
import org.mule.modules.quickbooks.online.schema.Vendor;

public enum OnlineEntityType {
    ACCOUNT(Account.class),
    BILL(Bill.class),
    BILLPAYMENT(BillPayment.class),
    CASHPURCHASE(CashPurchase.class),
    CHECK(Check.class),
    CREDITCARDCHARGE(CreditCardCharge.class),
    CUSTOMER(Customer.class),
    ESTIMATE(Estimate.class),
    INVOICE(Invoice.class),
    ITEM(Item.class),
    PAYMENT(Payment.class),
    PAYMENTMETHOD(PaymentMethod.class),
    SALESRECEIPT(SalesReceipt.class),
    SALESTERM(SalesTerm.class),
    VENDOR(Vendor.class),
    CHANGEDATADELETED(DeletedEntities.class, "changedatadeleted", "Entity"),
    COMPANY_METADATA(CompanyMetaData.class, "companymetadata", "Entity");

    private final Class<?> type;
    private final String simpleName;
    private final String cdmCollectionName;

    private OnlineEntityType(Class<?> type) {
        this.type = type;
        this.cdmCollectionName = this.simpleName = this.getType().getSimpleName();
    }

    private OnlineEntityType(Class<?> type, String simpleName, String cdmCollectionName) {
        this.type = type;
        this.simpleName = simpleName;
        this.cdmCollectionName = cdmCollectionName;
    }

    public <A> A newInstance() {
        try {
            return (A)this.type.newInstance();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getResouceName() {
        return QuickBooksConventions.toQuickBooksPathVariable((String)this.getSimpleName());
    }

    public String getResouceNameForFind() {
        String str = QuickBooksConventions.toQuickBooksPathVariable((String)this.getSimpleName());
        if (!this.type.equals(DeletedEntities.class)) {
            str = str + "s";
        }
        return str;
    }

    public String getCdmCollectionName() {
        return this.cdmCollectionName;
    }

    public <A> Class<A> getType() {
        return this.type;
    }

    public String getSimpleName() {
        return this.simpleName;
    }
}

