
package org.mule.modules.quickbooks.online.schema.transformers;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.quickbooks.online.processors.AbstractExpressionEvaluator;
import org.mule.modules.quickbooks.online.schema.AccountRef;
import org.mule.modules.quickbooks.online.schema.IdType;
import org.mule.modules.quickbooks.online.schema.Item;
import org.mule.modules.quickbooks.online.schema.ItemTypeEnum;
import org.mule.modules.quickbooks.online.schema.Money;
import org.mule.modules.quickbooks.online.schema.VendorRef;
import org.mule.modules.quickbooks.online.schema.holders.ItemExpressionHolder;
import org.mule.transformer.types.DataTypeFactory;

@Generated(value = "Mule DevKit Version 3.3.1", date = "2013-01-28T04:37:36-03:00", comments = "Build 3.3.1.1298.3ae82a7")
public class ItemExpressionHolderTransformer
    extends AbstractExpressionEvaluator
    implements DiscoverableTransformer, MessageTransformer
{

    private int weighting = DiscoverableTransformer.DEFAULT_PRIORITY_WEIGHTING;
    private ImmutableEndpoint endpoint;
    private MuleContext muleContext;
    private String name;

    public int getPriorityWeighting() {
        return weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

    public boolean isSourceTypeSupported(Class<?> aClass) {
        return (aClass == ItemExpressionHolder.class);
    }

    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return (dataType.getType() == ItemExpressionHolder.class);
    }

    public List<Class<?>> getSourceTypes() {
        return Arrays.asList(new Class<?> [] {ItemExpressionHolder.class });
    }

    public List<DataType<?>> getSourceDataTypes() {
        return Arrays.asList(new DataType<?> [] {DataTypeFactory.create(ItemExpressionHolder.class)});
    }

    public boolean isAcceptNull() {
        return false;
    }

    public boolean isIgnoreBadInput() {
        return false;
    }

    public Object transform(Object src)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public Object transform(Object src, String encoding)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public void setReturnClass(Class<?> theClass) {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnClass() {
        return Item.class;
    }

    public void setReturnDataType(DataType<?> type) {
        throw new UnsupportedOperationException();
    }

    public DataType<?> getReturnDataType() {
        return DataTypeFactory.create(Item.class);
    }

    public void setEndpoint(ImmutableEndpoint ep) {
        endpoint = ep;
    }

    public ImmutableEndpoint getEndpoint() {
        return endpoint;
    }

    public void dispose() {
    }

    public void initialise()
        throws InitialisationException
    {
    }

    public void setMuleContext(MuleContext context) {
        muleContext = context;
    }

    public void setName(String newName) {
        name = newName;
    }

    public String getName() {
        return name;
    }

    public Object transform(Object src, MuleEvent event)
        throws TransformerMessagingException
    {
        return transform(src, null, event);
    }

    public Object transform(Object src, String encoding, MuleEvent event)
        throws TransformerMessagingException
    {
        if (src == null) {
            return null;
        }
        ItemExpressionHolder holder = ((ItemExpressionHolder) src);
        Item result = new Item();
        try {
            final IdType _transformedItemParentId = ((IdType) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_itemParentIdType").getGenericType(), null, holder.getItemParentId()));
            result.setItemParentId(_transformedItemParentId);
            final String _transformedItemParentName = ((String) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_itemParentNameType").getGenericType(), null, holder.getItemParentName()));
            result.setItemParentName(_transformedItemParentName);
            final String _transformedName = ((String) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_nameType").getGenericType(), null, holder.getName()));
            result.setName(_transformedName);
            final String _transformedDesc = ((String) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_descType").getGenericType(), null, holder.getDesc()));
            result.setDesc(_transformedDesc);
            final Boolean _transformedTaxable = ((Boolean) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_taxableType").getGenericType(), null, holder.getTaxable()));
            result.setTaxable(_transformedTaxable);
            final Boolean _transformedActive = ((Boolean) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_activeType").getGenericType(), null, holder.getActive()));
            result.setActive(_transformedActive);
            final Money _transformedUnitPrice = ((Money) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_unitPriceType").getGenericType(), null, holder.getUnitPrice()));
            result.setUnitPrice(_transformedUnitPrice);
            final ItemTypeEnum _transformedType = ((ItemTypeEnum) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_typeType").getGenericType(), null, holder.getType()));
            result.setType(_transformedType);
            final AccountRef _transformedIncomeAccountRef = ((AccountRef) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_incomeAccountRefType").getGenericType(), null, holder.getIncomeAccountRef()));
            result.setIncomeAccountRef(_transformedIncomeAccountRef);
            final String _transformedPurchaseDesc = ((String) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_purchaseDescType").getGenericType(), null, holder.getPurchaseDesc()));
            result.setPurchaseDesc(_transformedPurchaseDesc);
            final Money _transformedPurchaseCost = ((Money) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_purchaseCostType").getGenericType(), null, holder.getPurchaseCost()));
            result.setPurchaseCost(_transformedPurchaseCost);
            final AccountRef _transformedExpenseAccountRef = ((AccountRef) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_expenseAccountRefType").getGenericType(), null, holder.getExpenseAccountRef()));
            result.setExpenseAccountRef(_transformedExpenseAccountRef);
            final AccountRef _transformedAssetAccountRef = ((AccountRef) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_assetAccountRefType").getGenericType(), null, holder.getAssetAccountRef()));
            result.setAssetAccountRef(_transformedAssetAccountRef);
            final VendorRef _transformedPrefVendorRef = ((VendorRef) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_prefVendorRefType").getGenericType(), null, holder.getPrefVendorRef()));
            result.setPrefVendorRef(_transformedPrefVendorRef);
            final Money _transformedAvgCost = ((Money) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_avgCostType").getGenericType(), null, holder.getAvgCost()));
            result.setAvgCost(_transformedAvgCost);
            final BigDecimal _transformedQtyOnHand = ((BigDecimal) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_qtyOnHandType").getGenericType(), null, holder.getQtyOnHand()));
            result.setQtyOnHand(_transformedQtyOnHand);
            final BigDecimal _transformedQtyOnPurchaseOrder = ((BigDecimal) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_qtyOnPurchaseOrderType").getGenericType(), null, holder.getQtyOnPurchaseOrder()));
            result.setQtyOnPurchaseOrder(_transformedQtyOnPurchaseOrder);
            final BigDecimal _transformedQtyOnSalesOrder = ((BigDecimal) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_qtyOnSalesOrderType").getGenericType(), null, holder.getQtyOnSalesOrder()));
            result.setQtyOnSalesOrder(_transformedQtyOnSalesOrder);
            final BigDecimal _transformedReorderPoint = ((BigDecimal) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_reorderPointType").getGenericType(), null, holder.getReorderPoint()));
            result.setReorderPoint(_transformedReorderPoint);
            final String _transformedManPartNum = ((String) evaluateAndTransform(this.muleContext, event, ItemExpressionHolder.class.getDeclaredField("_manPartNumType").getGenericType(), null, holder.getManPartNum()));
            result.setManPartNum(_transformedManPartNum);
        } catch (NoSuchFieldException e) {
            throw new TransformerMessagingException(CoreMessages.createStaticMessage("internal error"), event, this, e);
        } catch (TransformerException e) {
            throw new TransformerMessagingException(e.getI18nMessage(), event, this, e);
        }
        return result;
    }

    public MuleEvent process(MuleEvent event) {
        return null;
    }

    public String getMimeType() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public MuleContext getMuleContext() {
        return muleContext;
    }

}
