
package org.mule.modules.quickbooks.online.schema.transformers;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.quickbooks.online.processors.AbstractExpressionEvaluator;
import org.mule.modules.quickbooks.online.schema.EstimateHeader;
import org.mule.modules.quickbooks.online.schema.IdType;
import org.mule.modules.quickbooks.online.schema.PhysicalAddress;
import org.mule.modules.quickbooks.online.schema.holders.EstimateHeaderExpressionHolder;
import org.mule.transformer.types.DataTypeFactory;

@Generated(value = "Mule DevKit Version 3.3.1", date = "2013-01-28T04:37:36-03:00", comments = "Build 3.3.1.1298.3ae82a7")
public class EstimateHeaderExpressionHolderTransformer
    extends AbstractExpressionEvaluator
    implements DiscoverableTransformer, MessageTransformer
{

    private int weighting = DiscoverableTransformer.DEFAULT_PRIORITY_WEIGHTING;
    private ImmutableEndpoint endpoint;
    private MuleContext muleContext;
    private String name;

    public int getPriorityWeighting() {
        return weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

    public boolean isSourceTypeSupported(Class<?> aClass) {
        return (aClass == EstimateHeaderExpressionHolder.class);
    }

    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return (dataType.getType() == EstimateHeaderExpressionHolder.class);
    }

    public List<Class<?>> getSourceTypes() {
        return Arrays.asList(new Class<?> [] {EstimateHeaderExpressionHolder.class });
    }

    public List<DataType<?>> getSourceDataTypes() {
        return Arrays.asList(new DataType<?> [] {DataTypeFactory.create(EstimateHeaderExpressionHolder.class)});
    }

    public boolean isAcceptNull() {
        return false;
    }

    public boolean isIgnoreBadInput() {
        return false;
    }

    public Object transform(Object src)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public Object transform(Object src, String encoding)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public void setReturnClass(Class<?> theClass) {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnClass() {
        return EstimateHeader.class;
    }

    public void setReturnDataType(DataType<?> type) {
        throw new UnsupportedOperationException();
    }

    public DataType<?> getReturnDataType() {
        return DataTypeFactory.create(EstimateHeader.class);
    }

    public void setEndpoint(ImmutableEndpoint ep) {
        endpoint = ep;
    }

    public ImmutableEndpoint getEndpoint() {
        return endpoint;
    }

    public void dispose() {
    }

    public void initialise()
        throws InitialisationException
    {
    }

    public void setMuleContext(MuleContext context) {
        muleContext = context;
    }

    public void setName(String newName) {
        name = newName;
    }

    public String getName() {
        return name;
    }

    public Object transform(Object src, MuleEvent event)
        throws TransformerMessagingException
    {
        return transform(src, null, event);
    }

    public Object transform(Object src, String encoding, MuleEvent event)
        throws TransformerMessagingException
    {
        if (src == null) {
            return null;
        }
        EstimateHeaderExpressionHolder holder = ((EstimateHeaderExpressionHolder) src);
        EstimateHeader result = new EstimateHeader();
        try {
            final IdType _transformedSalesTermId = ((IdType) evaluateAndTransform(this.muleContext, event, EstimateHeaderExpressionHolder.class.getDeclaredField("_salesTermIdType").getGenericType(), null, holder.getSalesTermId()));
            result.setSalesTermId(_transformedSalesTermId);
            final String _transformedSalesTermName = ((String) evaluateAndTransform(this.muleContext, event, EstimateHeaderExpressionHolder.class.getDeclaredField("_salesTermNameType").getGenericType(), null, holder.getSalesTermName()));
            result.setSalesTermName(_transformedSalesTermName);
            final PhysicalAddress _transformedBillAddr = ((PhysicalAddress) evaluateAndTransform(this.muleContext, event, EstimateHeaderExpressionHolder.class.getDeclaredField("_billAddrType").getGenericType(), null, holder.getBillAddr()));
            result.setBillAddr(_transformedBillAddr);
            final PhysicalAddress _transformedShipAddr = ((PhysicalAddress) evaluateAndTransform(this.muleContext, event, EstimateHeaderExpressionHolder.class.getDeclaredField("_shipAddrType").getGenericType(), null, holder.getShipAddr()));
            result.setShipAddr(_transformedShipAddr);
            final String _transformedBillEmail = ((String) evaluateAndTransform(this.muleContext, event, EstimateHeaderExpressionHolder.class.getDeclaredField("_billEmailType").getGenericType(), null, holder.getBillEmail()));
            result.setBillEmail(_transformedBillEmail);
            final BigDecimal _transformedDiscountAmt = ((BigDecimal) evaluateAndTransform(this.muleContext, event, EstimateHeaderExpressionHolder.class.getDeclaredField("_discountAmtType").getGenericType(), null, holder.getDiscountAmt()));
            result.setDiscountAmt(_transformedDiscountAmt);
            final BigDecimal _transformedDiscountRate = ((BigDecimal) evaluateAndTransform(this.muleContext, event, EstimateHeaderExpressionHolder.class.getDeclaredField("_discountRateType").getGenericType(), null, holder.getDiscountRate()));
            result.setDiscountRate(_transformedDiscountRate);
            final IdType _transformedDiscountAccountId = ((IdType) evaluateAndTransform(this.muleContext, event, EstimateHeaderExpressionHolder.class.getDeclaredField("_discountAccountIdType").getGenericType(), null, holder.getDiscountAccountId()));
            result.setDiscountAccountId(_transformedDiscountAccountId);
            final String _transformedDiscountAccountName = ((String) evaluateAndTransform(this.muleContext, event, EstimateHeaderExpressionHolder.class.getDeclaredField("_discountAccountNameType").getGenericType(), null, holder.getDiscountAccountName()));
            result.setDiscountAccountName(_transformedDiscountAccountName);
            final Boolean _transformedDiscountTaxable = ((Boolean) evaluateAndTransform(this.muleContext, event, EstimateHeaderExpressionHolder.class.getDeclaredField("_discountTaxableType").getGenericType(), null, holder.getDiscountTaxable()));
            result.setDiscountTaxable(_transformedDiscountTaxable);
            final Date _transformedExpirationDate = ((Date) evaluateAndTransform(this.muleContext, event, EstimateHeaderExpressionHolder.class.getDeclaredField("_expirationDateType").getGenericType(), null, holder.getExpirationDate()));
            result.setExpirationDate(_transformedExpirationDate);
            final String _transformedAcceptedBy = ((String) evaluateAndTransform(this.muleContext, event, EstimateHeaderExpressionHolder.class.getDeclaredField("_acceptedByType").getGenericType(), null, holder.getAcceptedBy()));
            result.setAcceptedBy(_transformedAcceptedBy);
            final Date _transformedAcceptedDate = ((Date) evaluateAndTransform(this.muleContext, event, EstimateHeaderExpressionHolder.class.getDeclaredField("_acceptedDateType").getGenericType(), null, holder.getAcceptedDate()));
            result.setAcceptedDate(_transformedAcceptedDate);
        } catch (NoSuchFieldException e) {
            throw new TransformerMessagingException(CoreMessages.createStaticMessage("internal error"), event, this, e);
        } catch (TransformerException e) {
            throw new TransformerMessagingException(e.getI18nMessage(), event, this, e);
        }
        return result;
    }

    public MuleEvent process(MuleEvent event) {
        return null;
    }

    public String getMimeType() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public MuleContext getMuleContext() {
        return muleContext;
    }

}
