
package org.mule.modules.quickbooks.online.schema.transformers;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.quickbooks.online.processors.AbstractExpressionEvaluator;
import org.mule.modules.quickbooks.online.schema.Customer;
import org.mule.modules.quickbooks.online.schema.IdType;
import org.mule.modules.quickbooks.online.schema.JobInfo;
import org.mule.modules.quickbooks.online.schema.Money;
import org.mule.modules.quickbooks.online.schema.holders.CustomerExpressionHolder;
import org.mule.transformer.types.DataTypeFactory;

@Generated(value = "Mule DevKit Version 3.3.1", date = "2013-01-28T04:37:36-03:00", comments = "Build 3.3.1.1298.3ae82a7")
public class CustomerExpressionHolderTransformer
    extends AbstractExpressionEvaluator
    implements DiscoverableTransformer, MessageTransformer
{

    private int weighting = DiscoverableTransformer.DEFAULT_PRIORITY_WEIGHTING;
    private ImmutableEndpoint endpoint;
    private MuleContext muleContext;
    private String name;

    public int getPriorityWeighting() {
        return weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

    public boolean isSourceTypeSupported(Class<?> aClass) {
        return (aClass == CustomerExpressionHolder.class);
    }

    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return (dataType.getType() == CustomerExpressionHolder.class);
    }

    public List<Class<?>> getSourceTypes() {
        return Arrays.asList(new Class<?> [] {CustomerExpressionHolder.class });
    }

    public List<DataType<?>> getSourceDataTypes() {
        return Arrays.asList(new DataType<?> [] {DataTypeFactory.create(CustomerExpressionHolder.class)});
    }

    public boolean isAcceptNull() {
        return false;
    }

    public boolean isIgnoreBadInput() {
        return false;
    }

    public Object transform(Object src)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public Object transform(Object src, String encoding)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public void setReturnClass(Class<?> theClass) {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnClass() {
        return Customer.class;
    }

    public void setReturnDataType(DataType<?> type) {
        throw new UnsupportedOperationException();
    }

    public DataType<?> getReturnDataType() {
        return DataTypeFactory.create(Customer.class);
    }

    public void setEndpoint(ImmutableEndpoint ep) {
        endpoint = ep;
    }

    public ImmutableEndpoint getEndpoint() {
        return endpoint;
    }

    public void dispose() {
    }

    public void initialise()
        throws InitialisationException
    {
    }

    public void setMuleContext(MuleContext context) {
        muleContext = context;
    }

    public void setName(String newName) {
        name = newName;
    }

    public String getName() {
        return name;
    }

    public Object transform(Object src, MuleEvent event)
        throws TransformerMessagingException
    {
        return transform(src, null, event);
    }

    public Object transform(Object src, String encoding, MuleEvent event)
        throws TransformerMessagingException
    {
        if (src == null) {
            return null;
        }
        CustomerExpressionHolder holder = ((CustomerExpressionHolder) src);
        Customer result = new Customer();
        try {
            final Boolean _transformedActive = ((Boolean) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_activeType").getGenericType(), null, holder.getActive()));
            result.setActive(_transformedActive);
            final String _transformedShowAs = ((String) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_showAsType").getGenericType(), null, holder.getShowAs()));
            result.setShowAs(_transformedShowAs);
            final IdType _transformedCustomerTypeId = ((IdType) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_customerTypeIdType").getGenericType(), null, holder.getCustomerTypeId()));
            result.setCustomerTypeId(_transformedCustomerTypeId);
            final String _transformedCustomerTypeName = ((String) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_customerTypeNameType").getGenericType(), null, holder.getCustomerTypeName()));
            result.setCustomerTypeName(_transformedCustomerTypeName);
            final IdType _transformedSalesTermId = ((IdType) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_salesTermIdType").getGenericType(), null, holder.getSalesTermId()));
            result.setSalesTermId(_transformedSalesTermId);
            final String _transformedSalesTermName = ((String) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_salesTermNameType").getGenericType(), null, holder.getSalesTermName()));
            result.setSalesTermName(_transformedSalesTermName);
            final IdType _transformedSalesRepId = ((IdType) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_salesRepIdType").getGenericType(), null, holder.getSalesRepId()));
            result.setSalesRepId(_transformedSalesRepId);
            final String _transformedSalesRepName = ((String) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_salesRepNameType").getGenericType(), null, holder.getSalesRepName()));
            result.setSalesRepName(_transformedSalesRepName);
            final IdType _transformedSalesTaxCodeId = ((IdType) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_salesTaxCodeIdType").getGenericType(), null, holder.getSalesTaxCodeId()));
            result.setSalesTaxCodeId(_transformedSalesTaxCodeId);
            final String _transformedSalesTaxCodeName = ((String) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_salesTaxCodeNameType").getGenericType(), null, holder.getSalesTaxCodeName()));
            result.setSalesTaxCodeName(_transformedSalesTaxCodeName);
            final IdType _transformedTaxId = ((IdType) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_taxIdType").getGenericType(), null, holder.getTaxId()));
            result.setTaxId(_transformedTaxId);
            final String _transformedTaxName = ((String) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_taxNameType").getGenericType(), null, holder.getTaxName()));
            result.setTaxName(_transformedTaxName);
            final IdType _transformedTaxGroupId = ((IdType) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_taxGroupIdType").getGenericType(), null, holder.getTaxGroupId()));
            result.setTaxGroupId(_transformedTaxGroupId);
            final String _transformedTaxGroupName = ((String) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_taxGroupNameType").getGenericType(), null, holder.getTaxGroupName()));
            result.setTaxGroupName(_transformedTaxGroupName);
            final IdType _transformedPaymentMethodId = ((IdType) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_paymentMethodIdType").getGenericType(), null, holder.getPaymentMethodId()));
            result.setPaymentMethodId(_transformedPaymentMethodId);
            final String _transformedPaymentMethodName = ((String) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_paymentMethodNameType").getGenericType(), null, holder.getPaymentMethodName()));
            result.setPaymentMethodName(_transformedPaymentMethodName);
            final IdType _transformedPriceLevelId = ((IdType) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_priceLevelIdType").getGenericType(), null, holder.getPriceLevelId()));
            result.setPriceLevelId(_transformedPriceLevelId);
            final String _transformedPriceLevelName = ((String) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_priceLevelNameType").getGenericType(), null, holder.getPriceLevelName()));
            result.setPriceLevelName(_transformedPriceLevelName);
            final Money _transformedOpenBalance = ((Money) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_openBalanceType").getGenericType(), null, holder.getOpenBalance()));
            result.setOpenBalance(_transformedOpenBalance);
            final Date _transformedOpenBalanceDate = ((Date) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_openBalanceDateType").getGenericType(), null, holder.getOpenBalanceDate()));
            result.setOpenBalanceDate(_transformedOpenBalanceDate);
            final Money _transformedOpenBalanceWithJobs = ((Money) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_openBalanceWithJobsType").getGenericType(), null, holder.getOpenBalanceWithJobs()));
            result.setOpenBalanceWithJobs(_transformedOpenBalanceWithJobs);
            final Money _transformedCreditLimit = ((Money) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_creditLimitType").getGenericType(), null, holder.getCreditLimit()));
            result.setCreditLimit(_transformedCreditLimit);
            final String _transformedAcctNum = ((String) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_acctNumType").getGenericType(), null, holder.getAcctNum()));
            result.setAcctNum(_transformedAcctNum);
            final Money _transformedOverDueBalance = ((Money) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_overDueBalanceType").getGenericType(), null, holder.getOverDueBalance()));
            result.setOverDueBalance(_transformedOverDueBalance);
            final Money _transformedTotalRevenue = ((Money) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_totalRevenueType").getGenericType(), null, holder.getTotalRevenue()));
            result.setTotalRevenue(_transformedTotalRevenue);
            final Money _transformedTotalExpense = ((Money) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_totalExpenseType").getGenericType(), null, holder.getTotalExpense()));
            result.setTotalExpense(_transformedTotalExpense);
            final JobInfo _transformedJobInfo = ((JobInfo) evaluateAndTransform(this.muleContext, event, CustomerExpressionHolder.class.getDeclaredField("_jobInfoType").getGenericType(), null, holder.getJobInfo()));
            result.setJobInfo(_transformedJobInfo);
        } catch (NoSuchFieldException e) {
            throw new TransformerMessagingException(CoreMessages.createStaticMessage("internal error"), event, this, e);
        } catch (TransformerException e) {
            throw new TransformerMessagingException(e.getI18nMessage(), event, this, e);
        }
        return result;
    }

    public MuleEvent process(MuleEvent event) {
        return null;
    }

    public String getMimeType() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public MuleContext getMuleContext() {
        return muleContext;
    }

}
