
package org.mule.modules.quickbooks.online.schema.transformers;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.quickbooks.online.processors.AbstractExpressionEvaluator;
import org.mule.modules.quickbooks.online.schema.CreditCardTypeEnum;
import org.mule.modules.quickbooks.online.schema.CreditChargeInfo;
import org.mule.modules.quickbooks.online.schema.holders.CreditChargeInfoExpressionHolder;
import org.mule.transformer.types.DataTypeFactory;

@Generated(value = "Mule DevKit Version 3.3.1", date = "2013-01-28T04:37:36-03:00", comments = "Build 3.3.1.1298.3ae82a7")
public class CreditChargeInfoExpressionHolderTransformer
    extends AbstractExpressionEvaluator
    implements DiscoverableTransformer, MessageTransformer
{

    private int weighting = DiscoverableTransformer.DEFAULT_PRIORITY_WEIGHTING;
    private ImmutableEndpoint endpoint;
    private MuleContext muleContext;
    private String name;

    public int getPriorityWeighting() {
        return weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

    public boolean isSourceTypeSupported(Class<?> aClass) {
        return (aClass == CreditChargeInfoExpressionHolder.class);
    }

    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return (dataType.getType() == CreditChargeInfoExpressionHolder.class);
    }

    public List<Class<?>> getSourceTypes() {
        return Arrays.asList(new Class<?> [] {CreditChargeInfoExpressionHolder.class });
    }

    public List<DataType<?>> getSourceDataTypes() {
        return Arrays.asList(new DataType<?> [] {DataTypeFactory.create(CreditChargeInfoExpressionHolder.class)});
    }

    public boolean isAcceptNull() {
        return false;
    }

    public boolean isIgnoreBadInput() {
        return false;
    }

    public Object transform(Object src)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public Object transform(Object src, String encoding)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public void setReturnClass(Class<?> theClass) {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnClass() {
        return CreditChargeInfo.class;
    }

    public void setReturnDataType(DataType<?> type) {
        throw new UnsupportedOperationException();
    }

    public DataType<?> getReturnDataType() {
        return DataTypeFactory.create(CreditChargeInfo.class);
    }

    public void setEndpoint(ImmutableEndpoint ep) {
        endpoint = ep;
    }

    public ImmutableEndpoint getEndpoint() {
        return endpoint;
    }

    public void dispose() {
    }

    public void initialise()
        throws InitialisationException
    {
    }

    public void setMuleContext(MuleContext context) {
        muleContext = context;
    }

    public void setName(String newName) {
        name = newName;
    }

    public String getName() {
        return name;
    }

    public Object transform(Object src, MuleEvent event)
        throws TransformerMessagingException
    {
        return transform(src, null, event);
    }

    public Object transform(Object src, String encoding, MuleEvent event)
        throws TransformerMessagingException
    {
        if (src == null) {
            return null;
        }
        CreditChargeInfoExpressionHolder holder = ((CreditChargeInfoExpressionHolder) src);
        CreditChargeInfo result = new CreditChargeInfo();
        try {
            final String _transformedNumber = ((String) evaluateAndTransform(this.muleContext, event, CreditChargeInfoExpressionHolder.class.getDeclaredField("_numberType").getGenericType(), null, holder.getNumber()));
            result.setNumber(_transformedNumber);
            final String _transformedToken = ((String) evaluateAndTransform(this.muleContext, event, CreditChargeInfoExpressionHolder.class.getDeclaredField("_tokenType").getGenericType(), null, holder.getToken()));
            result.setToken(_transformedToken);
            final CreditCardTypeEnum _transformedType = ((CreditCardTypeEnum) evaluateAndTransform(this.muleContext, event, CreditChargeInfoExpressionHolder.class.getDeclaredField("_typeType").getGenericType(), null, holder.getType()));
            result.setType(_transformedType);
            final String _transformedNameOnAcct = ((String) evaluateAndTransform(this.muleContext, event, CreditChargeInfoExpressionHolder.class.getDeclaredField("_nameOnAcctType").getGenericType(), null, holder.getNameOnAcct()));
            result.setNameOnAcct(_transformedNameOnAcct);
            final Integer _transformedCcExpirMn = ((Integer) evaluateAndTransform(this.muleContext, event, CreditChargeInfoExpressionHolder.class.getDeclaredField("_ccExpirMnType").getGenericType(), null, holder.getCcExpirMn()));
            result.setCcExpirMn(_transformedCcExpirMn);
            final Integer _transformedCcExpirYr = ((Integer) evaluateAndTransform(this.muleContext, event, CreditChargeInfoExpressionHolder.class.getDeclaredField("_ccExpirYrType").getGenericType(), null, holder.getCcExpirYr()));
            result.setCcExpirYr(_transformedCcExpirYr);
            final String _transformedBillAddrStreet = ((String) evaluateAndTransform(this.muleContext, event, CreditChargeInfoExpressionHolder.class.getDeclaredField("_billAddrStreetType").getGenericType(), null, holder.getBillAddrStreet()));
            result.setBillAddrStreet(_transformedBillAddrStreet);
            final String _transformedZipCode = ((String) evaluateAndTransform(this.muleContext, event, CreditChargeInfoExpressionHolder.class.getDeclaredField("_zipCodeType").getGenericType(), null, holder.getZipCode()));
            result.setZipCode(_transformedZipCode);
            final String _transformedCvv = ((String) evaluateAndTransform(this.muleContext, event, CreditChargeInfoExpressionHolder.class.getDeclaredField("_cvvType").getGenericType(), null, holder.getCvv()));
            result.setCvv(_transformedCvv);
            final String _transformedCommercialCardCode = ((String) evaluateAndTransform(this.muleContext, event, CreditChargeInfoExpressionHolder.class.getDeclaredField("_commercialCardCodeType").getGenericType(), null, holder.getCommercialCardCode()));
            result.setCommercialCardCode(_transformedCommercialCardCode);
        } catch (NoSuchFieldException e) {
            throw new TransformerMessagingException(CoreMessages.createStaticMessage("internal error"), event, this, e);
        } catch (TransformerException e) {
            throw new TransformerMessagingException(e.getI18nMessage(), event, this, e);
        }
        return result;
    }

    public MuleEvent process(MuleEvent event) {
        return null;
    }

    public String getMimeType() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public MuleContext getMuleContext() {
        return muleContext;
    }

}
