
package org.mule.modules.quickbooks.online.schema.transformers;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.quickbooks.online.processors.AbstractExpressionEvaluator;
import org.mule.modules.quickbooks.online.schema.CashPurchaseHeader;
import org.mule.modules.quickbooks.online.schema.EntityTypeEnum;
import org.mule.modules.quickbooks.online.schema.IdType;
import org.mule.modules.quickbooks.online.schema.PhysicalAddress;
import org.mule.modules.quickbooks.online.schema.holders.CashPurchaseHeaderExpressionHolder;
import org.mule.transformer.types.DataTypeFactory;

@Generated(value = "Mule DevKit Version 3.3.1", date = "2013-01-28T04:37:36-03:00", comments = "Build 3.3.1.1298.3ae82a7")
public class CashPurchaseHeaderExpressionHolderTransformer
    extends AbstractExpressionEvaluator
    implements DiscoverableTransformer, MessageTransformer
{

    private int weighting = DiscoverableTransformer.DEFAULT_PRIORITY_WEIGHTING;
    private ImmutableEndpoint endpoint;
    private MuleContext muleContext;
    private String name;

    public int getPriorityWeighting() {
        return weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

    public boolean isSourceTypeSupported(Class<?> aClass) {
        return (aClass == CashPurchaseHeaderExpressionHolder.class);
    }

    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return (dataType.getType() == CashPurchaseHeaderExpressionHolder.class);
    }

    public List<Class<?>> getSourceTypes() {
        return Arrays.asList(new Class<?> [] {CashPurchaseHeaderExpressionHolder.class });
    }

    public List<DataType<?>> getSourceDataTypes() {
        return Arrays.asList(new DataType<?> [] {DataTypeFactory.create(CashPurchaseHeaderExpressionHolder.class)});
    }

    public boolean isAcceptNull() {
        return false;
    }

    public boolean isIgnoreBadInput() {
        return false;
    }

    public Object transform(Object src)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public Object transform(Object src, String encoding)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public void setReturnClass(Class<?> theClass) {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnClass() {
        return CashPurchaseHeader.class;
    }

    public void setReturnDataType(DataType<?> type) {
        throw new UnsupportedOperationException();
    }

    public DataType<?> getReturnDataType() {
        return DataTypeFactory.create(CashPurchaseHeader.class);
    }

    public void setEndpoint(ImmutableEndpoint ep) {
        endpoint = ep;
    }

    public ImmutableEndpoint getEndpoint() {
        return endpoint;
    }

    public void dispose() {
    }

    public void initialise()
        throws InitialisationException
    {
    }

    public void setMuleContext(MuleContext context) {
        muleContext = context;
    }

    public void setName(String newName) {
        name = newName;
    }

    public String getName() {
        return name;
    }

    public Object transform(Object src, MuleEvent event)
        throws TransformerMessagingException
    {
        return transform(src, null, event);
    }

    public Object transform(Object src, String encoding, MuleEvent event)
        throws TransformerMessagingException
    {
        if (src == null) {
            return null;
        }
        CashPurchaseHeaderExpressionHolder holder = ((CashPurchaseHeaderExpressionHolder) src);
        CashPurchaseHeader result = new CashPurchaseHeader();
        try {
            final IdType _transformedCashAccountId = ((IdType) evaluateAndTransform(this.muleContext, event, CashPurchaseHeaderExpressionHolder.class.getDeclaredField("_cashAccountIdType").getGenericType(), null, holder.getCashAccountId()));
            result.setCashAccountId(_transformedCashAccountId);
            final String _transformedCashAccountName = ((String) evaluateAndTransform(this.muleContext, event, CashPurchaseHeaderExpressionHolder.class.getDeclaredField("_cashAccountNameType").getGenericType(), null, holder.getCashAccountName()));
            result.setCashAccountName(_transformedCashAccountName);
            final IdType _transformedEntityId = ((IdType) evaluateAndTransform(this.muleContext, event, CashPurchaseHeaderExpressionHolder.class.getDeclaredField("_entityIdType").getGenericType(), null, holder.getEntityId()));
            result.setEntityId(_transformedEntityId);
            final String _transformedEntityName = ((String) evaluateAndTransform(this.muleContext, event, CashPurchaseHeaderExpressionHolder.class.getDeclaredField("_entityNameType").getGenericType(), null, holder.getEntityName()));
            result.setEntityName(_transformedEntityName);
            final EntityTypeEnum _transformedEntityType = ((EntityTypeEnum) evaluateAndTransform(this.muleContext, event, CashPurchaseHeaderExpressionHolder.class.getDeclaredField("_entityTypeType").getGenericType(), null, holder.getEntityType()));
            result.setEntityType(_transformedEntityType);
            final PhysicalAddress _transformedPayeeAddr = ((PhysicalAddress) evaluateAndTransform(this.muleContext, event, CashPurchaseHeaderExpressionHolder.class.getDeclaredField("_payeeAddrType").getGenericType(), null, holder.getPayeeAddr()));
            result.setPayeeAddr(_transformedPayeeAddr);
            final BigDecimal _transformedTotalAmt = ((BigDecimal) evaluateAndTransform(this.muleContext, event, CashPurchaseHeaderExpressionHolder.class.getDeclaredField("_totalAmtType").getGenericType(), null, holder.getTotalAmt()));
            result.setTotalAmt(_transformedTotalAmt);
            final IdType _transformedTxnId = ((IdType) evaluateAndTransform(this.muleContext, event, CashPurchaseHeaderExpressionHolder.class.getDeclaredField("_txnIdType").getGenericType(), null, holder.getTxnId()));
            result.setTxnId(_transformedTxnId);
            final String _transformedTxnNum = ((String) evaluateAndTransform(this.muleContext, event, CashPurchaseHeaderExpressionHolder.class.getDeclaredField("_txnNumType").getGenericType(), null, holder.getTxnNum()));
            result.setTxnNum(_transformedTxnNum);
        } catch (NoSuchFieldException e) {
            throw new TransformerMessagingException(CoreMessages.createStaticMessage("internal error"), event, this, e);
        } catch (TransformerException e) {
            throw new TransformerMessagingException(e.getI18nMessage(), event, this, e);
        }
        return result;
    }

    public MuleEvent process(MuleEvent event) {
        return null;
    }

    public String getMimeType() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public MuleContext getMuleContext() {
        return muleContext;
    }

}
