
package org.mule.modules.quickbooks.online.schema.transformers;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.quickbooks.online.processors.AbstractExpressionEvaluator;
import org.mule.modules.quickbooks.online.schema.BillHeader;
import org.mule.modules.quickbooks.online.schema.IdType;
import org.mule.modules.quickbooks.online.schema.PhysicalAddress;
import org.mule.modules.quickbooks.online.schema.holders.BillHeaderExpressionHolder;
import org.mule.transformer.types.DataTypeFactory;

@Generated(value = "Mule DevKit Version 3.3.1", date = "2013-01-28T04:37:36-03:00", comments = "Build 3.3.1.1298.3ae82a7")
public class BillHeaderExpressionHolderTransformer
    extends AbstractExpressionEvaluator
    implements DiscoverableTransformer, MessageTransformer
{

    private int weighting = DiscoverableTransformer.DEFAULT_PRIORITY_WEIGHTING;
    private ImmutableEndpoint endpoint;
    private MuleContext muleContext;
    private String name;

    public int getPriorityWeighting() {
        return weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

    public boolean isSourceTypeSupported(Class<?> aClass) {
        return (aClass == BillHeaderExpressionHolder.class);
    }

    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return (dataType.getType() == BillHeaderExpressionHolder.class);
    }

    public List<Class<?>> getSourceTypes() {
        return Arrays.asList(new Class<?> [] {BillHeaderExpressionHolder.class });
    }

    public List<DataType<?>> getSourceDataTypes() {
        return Arrays.asList(new DataType<?> [] {DataTypeFactory.create(BillHeaderExpressionHolder.class)});
    }

    public boolean isAcceptNull() {
        return false;
    }

    public boolean isIgnoreBadInput() {
        return false;
    }

    public Object transform(Object src)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public Object transform(Object src, String encoding)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public void setReturnClass(Class<?> theClass) {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnClass() {
        return BillHeader.class;
    }

    public void setReturnDataType(DataType<?> type) {
        throw new UnsupportedOperationException();
    }

    public DataType<?> getReturnDataType() {
        return DataTypeFactory.create(BillHeader.class);
    }

    public void setEndpoint(ImmutableEndpoint ep) {
        endpoint = ep;
    }

    public ImmutableEndpoint getEndpoint() {
        return endpoint;
    }

    public void dispose() {
    }

    public void initialise()
        throws InitialisationException
    {
    }

    public void setMuleContext(MuleContext context) {
        muleContext = context;
    }

    public void setName(String newName) {
        name = newName;
    }

    public String getName() {
        return name;
    }

    public Object transform(Object src, MuleEvent event)
        throws TransformerMessagingException
    {
        return transform(src, null, event);
    }

    public Object transform(Object src, String encoding, MuleEvent event)
        throws TransformerMessagingException
    {
        if (src == null) {
            return null;
        }
        BillHeaderExpressionHolder holder = ((BillHeaderExpressionHolder) src);
        BillHeader result = new BillHeader();
        try {
            final IdType _transformedPayerId = ((IdType) evaluateAndTransform(this.muleContext, event, BillHeaderExpressionHolder.class.getDeclaredField("_payerIdType").getGenericType(), null, holder.getPayerId()));
            result.setPayerId(_transformedPayerId);
            final String _transformedPayerName = ((String) evaluateAndTransform(this.muleContext, event, BillHeaderExpressionHolder.class.getDeclaredField("_payerNameType").getGenericType(), null, holder.getPayerName()));
            result.setPayerName(_transformedPayerName);
            final IdType _transformedSalesTermId = ((IdType) evaluateAndTransform(this.muleContext, event, BillHeaderExpressionHolder.class.getDeclaredField("_salesTermIdType").getGenericType(), null, holder.getSalesTermId()));
            result.setSalesTermId(_transformedSalesTermId);
            final String _transformedSalesTermName = ((String) evaluateAndTransform(this.muleContext, event, BillHeaderExpressionHolder.class.getDeclaredField("_salesTermNameType").getGenericType(), null, holder.getSalesTermName()));
            result.setSalesTermName(_transformedSalesTermName);
            final Date _transformedDueDate = ((Date) evaluateAndTransform(this.muleContext, event, BillHeaderExpressionHolder.class.getDeclaredField("_dueDateType").getGenericType(), null, holder.getDueDate()));
            result.setDueDate(_transformedDueDate);
            final PhysicalAddress _transformedRemitToAddr = ((PhysicalAddress) evaluateAndTransform(this.muleContext, event, BillHeaderExpressionHolder.class.getDeclaredField("_remitToAddrType").getGenericType(), null, holder.getRemitToAddr()));
            result.setRemitToAddr(_transformedRemitToAddr);
            final PhysicalAddress _transformedShipAddr = ((PhysicalAddress) evaluateAndTransform(this.muleContext, event, BillHeaderExpressionHolder.class.getDeclaredField("_shipAddrType").getGenericType(), null, holder.getShipAddr()));
            result.setShipAddr(_transformedShipAddr);
            final BigDecimal _transformedBalance = ((BigDecimal) evaluateAndTransform(this.muleContext, event, BillHeaderExpressionHolder.class.getDeclaredField("_balanceType").getGenericType(), null, holder.getBalance()));
            result.setBalance(_transformedBalance);
            final List<IdType> _transformedTxnId = ((List<IdType> ) evaluateAndTransform(this.muleContext, event, BillHeaderExpressionHolder.class.getDeclaredField("_txnIdType").getGenericType(), null, holder.getTxnId()));
            result.setTxnId(_transformedTxnId);
        } catch (NoSuchFieldException e) {
            throw new TransformerMessagingException(CoreMessages.createStaticMessage("internal error"), event, this, e);
        } catch (TransformerException e) {
            throw new TransformerMessagingException(e.getI18nMessage(), event, this, e);
        }
        return result;
    }

    public MuleEvent process(MuleEvent event) {
        return null;
    }

    public String getMimeType() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public MuleContext getMuleContext() {
        return muleContext;
    }

}
