
package org.mule.modules.quickbooks.online.schema.transformers;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.quickbooks.online.processors.AbstractExpressionEvaluator;
import org.mule.modules.quickbooks.online.schema.Account;
import org.mule.modules.quickbooks.online.schema.AccountTypeEnum;
import org.mule.modules.quickbooks.online.schema.IdType;
import org.mule.modules.quickbooks.online.schema.holders.AccountExpressionHolder;
import org.mule.transformer.types.DataTypeFactory;

@Generated(value = "Mule DevKit Version 3.3.1", date = "2013-01-28T04:37:36-03:00", comments = "Build 3.3.1.1298.3ae82a7")
public class AccountExpressionHolderTransformer
    extends AbstractExpressionEvaluator
    implements DiscoverableTransformer, MessageTransformer
{

    private int weighting = DiscoverableTransformer.DEFAULT_PRIORITY_WEIGHTING;
    private ImmutableEndpoint endpoint;
    private MuleContext muleContext;
    private String name;

    public int getPriorityWeighting() {
        return weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

    public boolean isSourceTypeSupported(Class<?> aClass) {
        return (aClass == AccountExpressionHolder.class);
    }

    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return (dataType.getType() == AccountExpressionHolder.class);
    }

    public List<Class<?>> getSourceTypes() {
        return Arrays.asList(new Class<?> [] {AccountExpressionHolder.class });
    }

    public List<DataType<?>> getSourceDataTypes() {
        return Arrays.asList(new DataType<?> [] {DataTypeFactory.create(AccountExpressionHolder.class)});
    }

    public boolean isAcceptNull() {
        return false;
    }

    public boolean isIgnoreBadInput() {
        return false;
    }

    public Object transform(Object src)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public Object transform(Object src, String encoding)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public void setReturnClass(Class<?> theClass) {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnClass() {
        return Account.class;
    }

    public void setReturnDataType(DataType<?> type) {
        throw new UnsupportedOperationException();
    }

    public DataType<?> getReturnDataType() {
        return DataTypeFactory.create(Account.class);
    }

    public void setEndpoint(ImmutableEndpoint ep) {
        endpoint = ep;
    }

    public ImmutableEndpoint getEndpoint() {
        return endpoint;
    }

    public void dispose() {
    }

    public void initialise()
        throws InitialisationException
    {
    }

    public void setMuleContext(MuleContext context) {
        muleContext = context;
    }

    public void setName(String newName) {
        name = newName;
    }

    public String getName() {
        return name;
    }

    public Object transform(Object src, MuleEvent event)
        throws TransformerMessagingException
    {
        return transform(src, null, event);
    }

    public Object transform(Object src, String encoding, MuleEvent event)
        throws TransformerMessagingException
    {
        if (src == null) {
            return null;
        }
        AccountExpressionHolder holder = ((AccountExpressionHolder) src);
        Account result = new Account();
        try {
            final String _transformedName = ((String) evaluateAndTransform(this.muleContext, event, AccountExpressionHolder.class.getDeclaredField("_nameType").getGenericType(), null, holder.getName()));
            result.setName(_transformedName);
            final IdType _transformedAccountParentId = ((IdType) evaluateAndTransform(this.muleContext, event, AccountExpressionHolder.class.getDeclaredField("_accountParentIdType").getGenericType(), null, holder.getAccountParentId()));
            result.setAccountParentId(_transformedAccountParentId);
            final String _transformedAccountParentName = ((String) evaluateAndTransform(this.muleContext, event, AccountExpressionHolder.class.getDeclaredField("_accountParentNameType").getGenericType(), null, holder.getAccountParentName()));
            result.setAccountParentName(_transformedAccountParentName);
            final String _transformedDesc = ((String) evaluateAndTransform(this.muleContext, event, AccountExpressionHolder.class.getDeclaredField("_descType").getGenericType(), null, holder.getDesc()));
            result.setDesc(_transformedDesc);
            final Boolean _transformedActive = ((Boolean) evaluateAndTransform(this.muleContext, event, AccountExpressionHolder.class.getDeclaredField("_activeType").getGenericType(), null, holder.getActive()));
            result.setActive(_transformedActive);
            final AccountTypeEnum _transformedType = ((AccountTypeEnum) evaluateAndTransform(this.muleContext, event, AccountExpressionHolder.class.getDeclaredField("_typeType").getGenericType(), null, holder.getType()));
            result.setType(_transformedType);
            final String _transformedSubtype = ((String) evaluateAndTransform(this.muleContext, event, AccountExpressionHolder.class.getDeclaredField("_subtypeType").getGenericType(), null, holder.getSubtype()));
            result.setSubtype(_transformedSubtype);
            final String _transformedAcctNum = ((String) evaluateAndTransform(this.muleContext, event, AccountExpressionHolder.class.getDeclaredField("_acctNumType").getGenericType(), null, holder.getAcctNum()));
            result.setAcctNum(_transformedAcctNum);
            final String _transformedBankNum = ((String) evaluateAndTransform(this.muleContext, event, AccountExpressionHolder.class.getDeclaredField("_bankNumType").getGenericType(), null, holder.getBankNum()));
            result.setBankNum(_transformedBankNum);
            final String _transformedRoutingNum = ((String) evaluateAndTransform(this.muleContext, event, AccountExpressionHolder.class.getDeclaredField("_routingNumType").getGenericType(), null, holder.getRoutingNum()));
            result.setRoutingNum(_transformedRoutingNum);
            final BigDecimal _transformedOpeningBalance = ((BigDecimal) evaluateAndTransform(this.muleContext, event, AccountExpressionHolder.class.getDeclaredField("_openingBalanceType").getGenericType(), null, holder.getOpeningBalance()));
            result.setOpeningBalance(_transformedOpeningBalance);
            final Date _transformedOpeningBalanceDate = ((Date) evaluateAndTransform(this.muleContext, event, AccountExpressionHolder.class.getDeclaredField("_openingBalanceDateType").getGenericType(), null, holder.getOpeningBalanceDate()));
            result.setOpeningBalanceDate(_transformedOpeningBalanceDate);
            final BigDecimal _transformedCurrentBalance = ((BigDecimal) evaluateAndTransform(this.muleContext, event, AccountExpressionHolder.class.getDeclaredField("_currentBalanceType").getGenericType(), null, holder.getCurrentBalance()));
            result.setCurrentBalance(_transformedCurrentBalance);
            final BigDecimal _transformedCurrentBalanceWithSubAccounts = ((BigDecimal) evaluateAndTransform(this.muleContext, event, AccountExpressionHolder.class.getDeclaredField("_currentBalanceWithSubAccountsType").getGenericType(), null, holder.getCurrentBalanceWithSubAccounts()));
            result.setCurrentBalanceWithSubAccounts(_transformedCurrentBalanceWithSubAccounts);
        } catch (NoSuchFieldException e) {
            throw new TransformerMessagingException(CoreMessages.createStaticMessage("internal error"), event, this, e);
        } catch (TransformerException e) {
            throw new TransformerMessagingException(e.getI18nMessage(), event, this, e);
        }
        return result;
    }

    public MuleEvent process(MuleEvent event) {
        return null;
    }

    public String getMimeType() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public MuleContext getMuleContext() {
        return muleContext;
    }

}
